#include "mbed.h"
#include "ESP826601.h"

Esp ESP;
DigitalOut myled(LED1);
Ticker tick;

void readData(){
    myled = !myled;
}

int main() {
    tick.attach(&readData, 0.5);
    
    ESP.init();
    ESP.send("AT+CIFSR");
    ESP.waitResponse();
    ESP.send("AT+CIPMUX=1");
    ESP.waitResponse();
    ESP.send("AT+CIPSERVER=1,80");
    ESP.waitResponse();
    
    tick.detach();
    myled = 0;
    
    while(1){
        ESP.waitConnection();
        ESP.send("Pozdrav od Zvonimira");
        ESP.closeConnection();
    }
}


