#include "ESP826601.h"
#include "mbed.h"

Serial pc(USBTX, USBRX, 115200);
Serial esp(p28, p27, 115200);
DigitalOut reset(p26);

bool flag = false;
bool flagConnection = false;
bool flagSend = false;

char connection = '0';

char command[500]; 
int counter = 0;

Esp::Esp(){}

void Esp::init(void){
    reset = 0;
    wait(0.2);
    reset = 1;
    wait(5);
    esp.attach(&ESP_interrupt, Serial::RxIrq);
    pc.printf("------------\n");
}

void Esp::send(char* text){
    pc.printf("PC: ");
    pc.printf(text);
    pc.putc('\r');
    esp.printf(text);
    esp.printf("\r\n");
}

void Esp::waitResponse(){
    while(!flag){
        wait_ms(100);    
    }
    flag = false;  
}

void Esp::waitConnection(){
    while(!flagConnection){
        wait_ms(100);   
    }  
    flagConnection = false;  
    
    esp.printf("AT+CIPSEND=");
    esp.putc(connection);
    esp.printf(",20\r\n");
    
    Esp::waitResponse();
}

void Esp::closeConnection(){
    while(!flagSend){
        wait_ms(100); 
    }
    flagSend = false;
    
    esp.printf("AT+CIPCLOSE=");
    esp.putc(connection);
    esp.printf("\r\n");
    
    Esp::waitResponse();
}

void Esp::printToPC(char* text){
    pc.printf(text);
}

void Esp::printToPC(char c){
    pc.putc(c);
}

void ESP_interrupt(){
    char c = esp.getc();
    if(c == '\n' || c == '\r'){
        if(counter != 0){
            pc.printf("ESP: ");
            for(int i=0; i<counter; i++) pc.putc(command[i]);
            pc.putc('\r');
            counter = 0;
            if(command[0] == 'O' && command[1] == 'K') flag = true;
            if(command[2] == 'C' && command[3] == 'O' && command[4] == 'N' && command[5] == 'N') {
                connection = command[0];
                flagConnection = true;
            }
            if(command[0] == 'S' && command[1] == 'E' && command[2] == 'N' && command[3] == 'D') flagSend = true;
        }
    }else {
        command[counter] = c;
        counter++;  
    }
}