#include <stdio.h>
#include <stdlib.h>
#include "mbed.h"
#include "m3pi.h"

#define BUF_SIZE 128
#define ERROR   1
#define OK      0

//max/min speed
#define MAX 1.0
#define MIN 0.1

DigitalOut xbeeReset(p26);    //reset on Xbee

Serial pc(USBTX, USBRX); // tx, rx, interface with PC
Serial xbee(p28, p27);  //tx, rx, interface with xbee

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

m3pi pi;

volatile int mode;
#define MANUAL_MODE 0
#define LINE_FOLLOW_MODE 1
#define TURN_MODE 2
#define NUDGE_MODE 3

bool comm_time;

volatile double leftspeed;
volatile double rightspeed;
volatile double line_position;

char received[1024];
int r_index;
int sensors[5];

// GAINS/Params
//////////////////////////////
double k_p = 0.1;
double k_i = 0.0;
double k_d = 0.0;
double speed = 0.3;
//////////////////////////////

Ticker communication;
Ticker controls;
