#include "mbed.h"
#include "ESP8266.h"
#include "RangeFinder.h"
 
//Rangefinder Init
RangeFinder rf(D2, 10, 5800.0, 100000);
 
Serial pc(USBTX,USBRX);

//sensor 
AnalogIn lightSensor(A1);
PwmOut pwm(PTD0);

//wifi UART port and baud rate
ESP8266 wifi(PTC17, PTC16, 115200); 


//buffers for wifi library
char resp[1000];
char http_cmd[300], comm[300];

//lightsensor reading
float lightRead = 0.0f;

int timeout = 8000; //timeout for wifi commands

//system state
int state = 0;

//SSID and password for connection
#define SSID "ATT4fpt8dY" 
#define PASS "8k#ua9zy%4ue"  

//Remote IP
#define IP "184.106.153.149"


//Update key for thingspeak
char* Update_Key = "H67JROEREPXPGPFZ";
 
//Wifi init function
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}

void wifi_send(void){  

    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    //create link 
    sprintf(http_cmd,"/update?api_key=%s&field1=%f",Update_Key,lightRead); 
    pc.printf(http_cmd);
    
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while sending URL \r\n");
}

int main () {
    pwm.period_ms(20) ;
    wifi_initialize();
    float d;
    int count = 0;
    
    
    
    while (1) {
        printf("running\n");
        lightRead = 1 - lightSensor.read();
        d = rf.read_m();
        
        switch(state){
            case 0:
                if(d < 0.2f){
                    state = 1;    
                }break;
            case 1:
                pwm.pulsewidth_us(2400);
                wait(1);
                pwm.pulsewidth_us(1000);
                wait(1);
                state = 2;
                break;
            case 2:
                if(d > 0.6f){state = 0;}break;
        }
        if(count == 500){wifi_send();count = 0;}
        count++;
        //
    }
}