#include "mbed.h"
#include "Dht11.h"
#include "Grove_LCD_RGB_Backlight.h"

Serial pc(USBTX, USBRX);
Dht11 dhtSensor(D7);

AnalogIn lightSensor(A1);

Grove_LCD_RGB_Backlight rgbLCD(I2C_SDA, I2C_SCL);

DigitalOut Red(LED1); 
DigitalOut Green(LED2); 
DigitalOut Blue(LED3); 

float temperature = 0.0f;
float humidity = 0.0f;
float lightdens = 0.0f;

int main()
{
    rgbLCD.setRGB(0xff, 0xff, 0xff); 
    char szBuff[10];
    
    while(1){
        dhtSensor.read();
        temperature = dhtSensor.getCelsius();
        humidity = dhtSensor.getHumidity();
        
        lightdens = lightSensor.read();
        
        printf("Temp: %f, Hum: %f\n", temperature, humidity);
        printf("Light: %2.2f\n", lightdens);
        
        rgbLCD.locate(0,0);
        rgbLCD.print("T:");
        rgbLCD.locate(2,0);
        sprintf(szBuff, "%2.1f", temperature);
        rgbLCD.print(szBuff);
        
        rgbLCD.locate(8,0);
        rgbLCD.print("H:");
        rgbLCD.locate(10,0);
        sprintf(szBuff, "%2.1f", humidity);
        rgbLCD.print(szBuff);
        
        rgbLCD.locate(0,1);
        rgbLCD.print("Light:");
        rgbLCD.locate(6,1);
        sprintf(szBuff, "%2.1f", lightdens);
        rgbLCD.print(szBuff);
        
        if(temperature > 30.0f){Red = 0;}
        else if(temperature < 15.0f){Blue = 0;}
        else{Blue = 1; Red = 1;}
        
        if(humidity < 30.0f){Green = 0;}
        else{Green = 1;}
        
        wait(1);
    }
}