#ifndef TREE_H
#define TREE_H

/* The type of any binary or unary operators */
enum token_type {
    TOKEN_NUM,
    TOKEN_ADD,
    TOKEN_SUB,
    TOKEN_MUL,
    TOKEN_DIV,
    TOKEN_EXP,
    TOKEN_VAR,
    TOKEN_FUN,
    TOKEN_LPA,
    TOKEN_RPA
};


/* The type of any binary or unary operators */
enum op_type {
    OP_ADD,
    OP_SUB,
    OP_MUL,
    OP_DIV,
    OP_EXP
};

/* The type of each node */
enum node_type {
     NODE_NUMBER,       /* Holds one number in data.fval, no children */
     NODE_VAR,          /* Holds the name of the var in data.name  */
     NODE_BINOP,        /* Has the operator in op and both left and right children*/
     NODE_FUNC          /* Has the function name in data.name and a left child */
};


        
/* The structure that holds the parse tree */
struct node{
     enum node_type type;
     union data{
      float fval;
      char *name;
      enum op_type op;
     } data;
     struct node *left;
     struct node *right;
     struct node *parent;
};
              
/* Prints a tree of nodes, indenting as it descends the tree */
void print_node(struct node*);
/* Creates a new node of number type */
struct node* new_number_node(float num);
/* Creates a new node of var type */
struct node* new_var_node(char* str);
/* Creates a new node for a binary operator, with left and right children */
struct node* new_binop_node(enum op_type, struct node* left, struct node *right);
struct node* new_func_node(char* name, struct node* left);


#endif
