 /******************************************************************************
 - izpis vrednosti PIR motion senzorja, water sensor in sunlight senzorja na LCD
 - izpis PIR motion senzorja in Water senzorja na zaslon(serijska povezava z pc)
 - sprememba menijev z joystick LEFT in RIGHT
 - PIR motion senzor povezan na pin D2
 - water sensor povezan na D0
 - sunlight senzor povezan na D14(SDA), D15(SCL)
 *******************************************************************************/

#include "C12832.h"
#include "Arial12x12.h"
#include "rtos.h"
#include "SI1145.h"
#include "K64F.h"
#include "mbed.h"


int retryAttempt = 0;
int menuItem = 0;

char* joystickPos = "CENTRE";
int blink_interval = 0;

char* motion_state = "NOT DETECTED";
char* water_state = "NOT DETECTED";
char* risk = "";
bool motion_detected=0;
bool k = true;


int i=5, j=2;
int vis = 0;
int IR = 0;
float UV = 0;
float UV_real = 0;

/* PIR sensor interrupt*/
void pir_release(void)
{
    motion_detected=1;
}


/* Motion thread */
void motion(void const *args)
{
    while(1){
        if(motion_detected==1){
            motion_state = "DETECTED";
            pc.printf("Motion sensor detected!\n");
            motion_detected=0;
            i = 5;
        }      
        if(i==0){
            motion_state = "NOT DETECTED";
            i = 5;
        }
        i--;      
                
        Thread::wait(100);
    }
}

/* Sunlight sensor thread */
void sunlight(void const *args)
{
    while(1){
        
        vis = sensor.getVIS();
        IR = sensor.getIR();
        UV = sensor.getUV();
        UV_real = UV/100;
        
        if(0<=UV_real && UV_real<=2.9){
            risk = "Low";    
        }else if(3<=UV_real && UV_real<=5.9){
            risk = "Moderate";
        }else if(6<=UV_real && UV_real<=7.9){
            risk = "High";
        }else if(8<=UV_real && UV_real<=10.9){
            risk = "Very high";
        }else{
            risk = "Extreme";   
        }    
        
        Thread::wait(2000);
    }
}

/* Water sensor thread */
void water(void const *args)
{
    while(1){
        
        if(water_sensor == 0){
            water_state = "DETECTED";
            if(k == true){ 
                pc.printf("Water sensor detected!\n");
                k = false;
            }
            j = 2;
            
        }
        if(j==0){
            water_state = "NOT DETECTED";
            j = 2;
            k = true;
        }
        j--;
        
        Thread::wait(100);
    }
}

void printMenu(int menuItem) 
{
    static char last_line1[30] = "", last_line2[30] = "";
    char line1[30] = "", line2[30] = "";
        
    switch (menuItem)
    {
        case 0:
            sprintf(line1, "Sensor:");
            sprintf(line2, "%s", motion_state);
            break;
        case 1:
            sprintf(line1, "Water:");
            sprintf(line2, "%s", water_state);
            break;
        case 2:
            sprintf(line1, "Visible light:");
            sprintf(line2, "%d lm", vis);
            break; 
        case 3:
            sprintf(line1, "IR light:");
            sprintf(line2, "%d lm", IR);
            break;
        case 4:
            sprintf(line1, "UV Index(Risk):");
            sprintf(line2, "%.2f  (%s)", UV_real, risk);
            break;           
    }
    
    if (strcmp(line1, last_line1) != 0 || strcmp(line2, last_line2) != 0)
    {
        lcd.cls(); 
        lcd.locate(0, 0);
        lcd.printf(line1);
        strncpy(last_line1, line1, sizeof(last_line1));

        lcd.locate(0,16);
        lcd.printf(line2);
        strncpy(last_line2, line2, sizeof(last_line2));
    }
}


void setMenu()
{
    
    if (Down)
    {
        joystickPos = "DOWN";
        
    } 
    else if (Left){
        joystickPos = "LEFT";
        if(menuItem == 0)menuItem = 5;
        printMenu(--menuItem);
    }
    else if (Click)
        joystickPos = "CLICK";
    else if (Up)
    {
        joystickPos = "UP";
    }
    else if (Right){
        joystickPos = "RIGHT";
        if(menuItem == 4)menuItem = -1;
        printMenu(++menuItem);
    }
    else
        joystickPos = "CENTRE";
}

void menu_loop(void const *args)
{
    int count = 0;
    while(true)
    {
        setMenu();
        if (++count % 5 == 0)
            printMenu(menuItem);
        Thread::wait(100);
    }
}

int main()
{    
    /* Turn off leds */
    r = 1;  
    g = 1;
    b = 1; 

    lcd.set_font((unsigned char*) Arial12x12);  // Set a nice font for the LCD screen
    
    led2 = LED2_OFF; // K64F: turn off the main board LED 
        
    pir_motion.rise(&pir_release);
        
    Thread motion1(motion);
    Thread sunlight1(sunlight);
    Thread water1(water);
    Thread menu_thread(menu_loop);  
    
    while (true){}

}
