#include "ShiftRegister.h"
#include "mbed.h"
 
ShiftRegister::ShiftRegister():_clockPin(NC), _latchPin(NC), _dataPin(NC) {};
ShiftRegister::ShiftRegister(PinName clockPin, PinName latchPin, PinName dataPin)
  :_clockPin(clockPin), _latchPin(latchPin), _dataPin(dataPin)
{
    _clockPin = 0;
    _latchPin = 0;
    _dataPin = 0;
}
 
void ShiftRegister::shiftByte(unsigned char data)
{
    //Make sure all pins are initialised
    _clockPin = 0;
    _dataPin = 0;
    _latchPin = 0;
    
    //Shift out data
    for (int i=7; i>=0; i--)  
    {
        shiftBit( (data & (1<<i)) ? 1:0);
    }
    
    //Shift data to output
    _latchPin = 1;
    _latchPin = 0;
} 
 
void ShiftRegister::shiftBit(unsigned char bit)
{
    _clockPin = 0;
    _dataPin = bit;
    _clockPin = 1;
    _clockPin = 0;
    _dataPin = 0;

}