/**
|**********************************************************************;
* Project           : Projektarbeit Systemtechnik PES4
*
* Program name      : Beispiel
*
* Author            : PES4 Team1
*
* Team              : **Team 1**
*                     Fabio Bernard
*                     Lukas Egli
*                     Matthias Ott
*                     Pascal Novacki
*                     Robin Wanner
*                     Vincent Vescoli
*                     Cyrill Zoller
*
* Date created      : 20.02.2020
*
* Purpose           : Beispiel
*
|**********************************************************************;
**/


#ifndef CALCULATEDATA_H
#define CALCULATEDATA_H

#include "mbed.h"
#include "XNucleoIKS01A3.h"
#include "Liste.h"
#include "MahonyAHRS.h"

class CalculateData {

public:

    CalculateData(PinName Pin0, PinName Pin1, PinName Pin2,
                    PinName Pin3, PinName Pin4, PinName Pin5, PinName Pin6); //Constructor
                    
    virtual                     ~CalculateData();                
    void                        enable();
    void                        disable();
    void                        getValue(Liste *list);
    void                        update();
    
    

private:

    
    void                        integrate(float *x, float *x_old, float *y, float t, float t_old);
    void                        transform(int old_val[3][100], int index, float *new_val, int roll, int pitch, int yaw);
    void                        filterAcc(float *array);
    void                        filterSpeed(float *array);
    void                        run();
    void                        calibrationMag(int x,int y,int z, float *buff);

    
    
    Thread                      thread;
    Timer                       timer;
    MahonyAHRS                  *mahony;
    
    int                         array_acc[3][100];       //Matrix periodic Sensor Data
    int                         array_gyro[3][100];      //Matrix periodic Sensor Data
    int                         array_mag[3][100];      //Matrix periodic Sensor Data
    int                         counter;                //count Matrix records
    bool                        periodic_task;          //boolean periodic condition
    
    
    float                       acc[3];
    float                       acc_old[3];
    float                       speed[3];
    float                       speed_old[3];
    float                       pos[3];
    float                       t[100];
    float                       t_old;
  
    
};



#endif