/**
|**********************************************************************;
* Project           : Projektarbeit Systemtechnik PES4
*
* Program name      : Beispiel
*
* Author            : PES4 Team1
*
* Team              : **Team 1**
*                     Fabio Bernard
*                     Lukas Egli
*                     Matthias Ott
*                     Pascal Novacki
*                     Robin Wanner
*                     Vincent Vescoli
*                     Cyrill Zoller
*
* Date created      : 20.02.2020
*
* Purpose           : Beispiel
*
|**********************************************************************;
**/


#ifndef CALCULATEDATA_H
#define CALCULATEDATA_H

#include "mbed.h"
#include "XNucleoIKS01A3.h"
#include "Liste.h"

class CalculateData {

public:

    CalculateData(PinName Pin0, PinName Pin1, PinName Pin2,
                    PinName Pin3, PinName Pin4, PinName Pin5, PinName Pin6); //Constructor
                    
    virtual                     ~CalculateData();                
    void                        enable();
    void                        disable();
    void                        getValue(Liste *list);
    
    

private:

    
    void                        integrate(double *x, double *x_old, double *y, double t, double t_old);
    //void                        transform(int *acc, int *angle);
    void                        filterAcc(int array[3][30],int index, double *target);
    void                        filterGyro(int array[3][30],int index, double *target);
    void                        filterSpeed(double *array, double *target);
    void                        run();

    
    
    Thread                      thread;
    Timer                       timer;
    
    int                         array_acc[3][30];       //Matrix periodiv Sensor Data
    int                         array_gyro[3][30];      //Matrix periodiv Sensor Data
    int                         counter;                //count Matrix records
    bool                        periodic_task;          //boolean periodic condition
    
    
    int                         buf_acc[3];         
    int                         buf_gyro[3];
    double                      acc[3];         
    double                      gyro[3];
    double                      acc_old[3];
    double                      gyro_old[3];
    double                      speed[3];
    double                      speed_old[3];
    double                      angle[3];
    double                      pos[3];
    double                      t[30];
    double                      t_old;
  
    
};



#endif