#include "mbed.h"
#include "USBKeyboard.h"

// german kezboard?
#define QWERTZ

// reverse order, since message windows create a stack
const static char lyrics[][128] = {
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "gotta make you understand",
    "I just wanna tell you how I'm feeling ",
    "we know the game and we're gonna play it",
    "inside we both know what's been going on ",
    "your heart's been aching but you're too shy to say it ",
    "We've known each other for so long ",
    "never gonna give never gonna give you up",
    "never gonna give never gonna give you up",
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "don't tell me you're too blind to see",
    "And if you ask me how I'm feeling ",
    "we know the game and we're gonna play it",
    "inside we both know what's been going on ",
    "your heart's been aching but you're too shy to say it ",
    "We've known each other for so long ",
    "never gonna tell a lie and hurt you",
    "never gonna make you cry never gonna say goodbye ",
    "never gonna run around and desert you ",
    "Never gonna give you up never gonna let you down ",
    "gotta make you understand",
    "I just wanna tell you how I'm feeling ",
    "you wouldn't get this from any other guy",
    "a full commitment's what I'm thinkin' of ",
    "you know the rules and so do I ",
    "We're no strangers to love ",
    ""};

//USBKeyboard
USBKeyboard keyboard;

int main(void) {
    wait(2);
    while (1) {
        int line;
        for(line=0;lyrics[line][0];line++) {
            const char *p = lyrics[line];
            keyboard.keyCode('l', KEY_ALT);
            wait_ms(700);
            for(;*p;p++) {
                char c = *p;
#ifdef QWERTZ
                if (c == 'z')
                    c = 'y';
                else if (c == 'y')
                    c = 'z';
#endif                    
                if (c == 0x27)
                  continue;
                
                keyboard._putc(c);
            }
            keyboard.keyCode('s', KEY_ALT);
            wait_ms(700);
        }
    }
}
