#include "mbed.h"
#include "Servo.h"

//DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);

/*
The arch cookbook in mbed.org website
    http://mbed.org/users/viswesr/notebook/arch-cookbook/
*/
PwmOut servo(P1_24);    //seeedarch pin for the multiturn servo
Servo rudder(P1_25);    //seeedarch pin for the rudder servo

Serial bbb(P1_18,P1_17);//seeedarch pin for the UART communication tx, rx


AnalogIn ain(P0_11);//seeedarch analog in pin

void servo_initial(void);
void multiturn_servo(int type, int circle);

int main() 
{
    int circle=5;
    
    //servo_initial();
    bbb.baud(115200);
    while(~bbb.writeable());
    bbb.putc('s');
    while(1)
    {
         if(bbb.readable()) {
            bbb.putc(bbb.getc()+1);
        }    

    }
  
    while(1)
    {
        //Multiturn servo
        multiturn_servo(2,1);//20+10 degree
        multiturn_servo(0,10);
        multiturn_servo(2,1);//20+20 degree
        multiturn_servo(0,10);
        multiturn_servo(2,1);//50
        multiturn_servo(0,10);
        multiturn_servo(2,1);//60
        multiturn_servo(0,10);
        multiturn_servo(2,1);//70
        multiturn_servo(0,10);
        multiturn_servo(2,1);//80
        multiturn_servo(0,10); 
        
        
        //multiturn_servo(1,1);
        multiturn_servo(1,2);
        multiturn_servo(0,10);
        multiturn_servo(1,2);
        multiturn_servo(0,10);
        multiturn_servo(1,2);
        multiturn_servo(0,10);
        multiturn_servo(1,2);
        multiturn_servo(0,10);
        multiturn_servo(1,4);
        multiturn_servo(0,10);
        multiturn_servo(1,5);
        multiturn_servo(0,10);
        wait(2);
        
        //Rudder servo
        rudder.write(0.0);
        wait(0.01);
        wait(2);
        rudder.write(0.5);
        wait(0.01);
        wait(2);
        rudder.write(1.0);
        wait(0.01);
        wait(2);
     }      
}

void servo_initial()
{
        servo.period_ms(22);          //multiturn servo requires a 22ms period
        //Initial the position to far end
        multiturn_servo(1,10);
        multiturn_servo(0,20);
}

/*
    Control the multiturn servo to turn or stop it
    To turn the servo clockwise use pulsewidth 1.7 ms
    To turn the servo counter clockwise use pulsewidth 2.0 ms
    To stop the servo use the pulsewidth 10 ms
*/
void multiturn_servo(int type, int circle)
{
    float pulse_width=0.0;
    int i;
    
    switch(type)
    {
        case 0:
            pulse_width=10.0;//stop
            break;
        case 1:
            pulse_width=1.6;//counter clockwise
            break;
        case 2:
            pulse_width=2.0;//clockwise
            break;
    }
    for(i=0;i<circle;i++)
    {
        servo.pulsewidth_ms(pulse_width); // servo position determined by a pulsewidth between 1-2ms
        wait(0.25);
    }   

}