/***************************************************************/
/*                                                             */
/* Defines, enums, and typedefs for Space Invaders             */
/*                                                             */
/***************************************************************/
#define NUM_LIVES_START 3
#define NUM_ALIEN_COLS 5
#define NUM_ALIEN_ROWS 4
#define NUM_ALIENS_START (NUM_ALIEN_COLS * NUM_ALIEN_ROWS)
#define ALIEN_HEIGHT 4
#define ALIEN_WIDTH 5
#define SHIP_HEIGHT 4
#define SHIP_WIDTH 5
#define ELASER_CAP 3
#define RELOAD_TIME 40

#define SCREENHEIGHT 130
#define SCREENWIDTH 130

#define WHITE 0xFFFFFF
#define GREEN 0x00FF00
#define BLACK 0x0

#define WAIT4FULLPUSH(but) while(!(but)); while(but);
#define GOLEFT(hp) ((hp) < 0.25)
#define GORIGHT(hp) ((hp) > 0.75)

enum {START, GAME, LOSE, WIN};

typedef struct object {
    int y, x, height, width, color, killed;
} OBJECT;

typedef struct point {
    int y, x, color;
    bool collide;
} POINT;

/***************************************************************/
/*                                                             */
/* Global variables                                */
/*                                                             */
/***************************************************************/
extern OBJECT wave[NUM_ALIEN_ROWS][NUM_ALIEN_COLS], 
        wave_old[NUM_ALIEN_ROWS][NUM_ALIEN_COLS];

extern int state;
/***************************************************************/
/*                                                             */
/* Prototypes                                                  */
/*                                                             */
/***************************************************************/
OBJECT startShip();
void summonWave();
bool moveAlienWave(bool *pleft);
void destroyAlien(int *pals_rem, POINT *pylaser, OBJECT *frontline[]);
bool twoLasersCollide(POINT *pylaser, POINT elaser[]);