#include "mbed.h"
#include "sin_table.hpp"
#include "varicode_table.hpp"

DigitalOut myled(LED2);
DigitalOut port21(p21);
AnalogOut signal(p18);

Ticker lifepulse;
//Serial pc(USBTX, USBRX); // tx, rx


int deltaPhase;
double Ic, Qc, I, Q, bpsk;
double Ai                    = 1.0;                      // Next symbol phase
double Aq                    = 1.0;  

//const float Fc              = 400.0;                    // Carrier frequency in Hertz
//const float Fs              = 31.25;                    // Symbol frequency in Hertz
const float Tick_us         = 100.0;                    // Tick period in microseconds
//const float Tc              = (1/Fc);                   // Carrier signal period in seconds
//const float Ts              = (1/Fs);                   // Symbol signal period in seconds

double As                    = 0.001;

int SymbolCycles            = 320;
int HalfSymbolCycles        = 160;
int Cycles                  = 0;                        // Keep track of cycles for symbol coding
int SymbolTick              = 0;
int SymbolDeltaPhase        = 0;

char Message[] = " Welcome to mbed PSK31 beacon! ";
int MsgPtr = 0;
int  SymbolBitPos = 0;  // 15 positions
int  Zeros = 0;
int  ChangePhase = 0;
int  SendZeros = 60;

void get_next_symbol (void) 
{
    if (Message[MsgPtr] == NULL) {
        MsgPtr = 0;
        Zeros = 0;
        SymbolBitPos = 0;
    }
    if (SymbolBitPos == 16) {
        SymbolBitPos = 0;
    }
    
    if (((varicode[Message[MsgPtr]] << SymbolBitPos)&0x8000) == 0) {
        if (Ai > 0) {
            Ai = -1.0;
            Aq = -1.0;
        }
        else {
            Ai = 1.0;
            Aq = 1.0;
        }
        
        ChangePhase = 1;
        Zeros++;
        if (Zeros == 2) {
            MsgPtr++;
            Zeros = 0;
            SymbolBitPos = 0;
        }
        else        
            SymbolBitPos++;
    }
    else {
        ChangePhase = 0;
        Zeros = 0;
        SymbolBitPos++;
    }
}

void genpsk31() {
    
    signal = bpsk;

    // ==============================================================================
    // Carrier Frequency Part
    // ==============================================================================
    Ic = SIN[deltaPhase];
    Qc = COS[deltaPhase];

    deltaPhase++;
    if (deltaPhase == SIN_TABLE_SIZE) {
        deltaPhase = 0;
    }

    // ==============================================================================
    // Symbol Part
    // ==============================================================================
    
    // Is this end of BPSK period?
    if (Cycles == 0) {                          // Start of symbol period
        if (SendZeros) { 
            SendZeros--;     
            if (I < 0) {
                Ai = -1.0;
                Aq = -1.0;
            }
            else {
                Ai = 1.0;
                Aq = 1.0;
            }
            ChangePhase = 1;
        }
        else
            get_next_symbol();
    }
    
    if ((Cycles < HalfSymbolCycles)&&(ChangePhase==1)) {            // Transition to next phase
        I = Ai*SIN[SymbolDeltaPhase];
        Q = Aq*SIN[SymbolDeltaPhase];
    }
    else {
        if (I<0) I = Q = -1;
        else     I = Q =  1;
    }
    

    SymbolTick++;
    if (SymbolTick == 13) {
        SymbolTick = 0;
        SymbolDeltaPhase++;
        if (SymbolDeltaPhase == 20) SymbolDeltaPhase = 6;
    }
           
    Cycles++;
    if (Cycles == SymbolCycles) {
        if (port21) port21=0; else port21=1;
        //port21 = 1;
        Cycles = 0;    
        SymbolTick = 0;
        SymbolDeltaPhase = 6;
    }
        
    // ==============================================================================
    // Calculate BPSK
    // ==============================================================================
    bpsk = As*(I*Ic + Q*Qc) + 0.5;

    //port21 = 0;
}



int main() {
    deltaPhase = 0;
    Cycles = 0;
    I = 1.0;
    Q = 1.0;
    Ic = 1.0;
    Qc = 1.0;
    port21 = 0;
    lifepulse.attach_us(&genpsk31,Tick_us); 

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        //pc.printf("Hello World!\n\r");

    }
}


