#include "speech.h"

#include "globals.h"
#include "hardware.h"

/**
 * Draw the speech bubble background.
 */
static void draw_speech_bubble();

/**
 * Erase the speech bubble.
 */
static void erase_speech_bubble();

/**
 * Draw a single line of the speech bubble.
 * @param line The text to display
 * @param which If TOP, the first line; if BOTTOM, the second line.
 */
#define TOP 0
#define BOTTOM 1
static void draw_speech_line(const char *line, int which);

/**
 * Delay until it is time to scroll.
 */
static void speech_bubble_wait();

void draw_speech_bubble()
{
  uLCD.filled_rectangle(3, 93, 123, 113, GREEN);
  uLCD.filled_rectangle(4, 94, 122, 112, RED);
}

void erase_speech_bubble()
{
}

void draw_speech_line(const char *line, int which)
{
}

int readPB1(int pb1)
{
  GameInputs inputs;
  inputs = read_inputs();
  if (inputs.b1 == 0)
    pb1 = 0;
  return pb1;
}

void speech_bubble_wait()
{
  int pb1 = 1;
  while (pb1 == 1)
  {
    for (int i = 0; i < 4; i++)
    {
      uLCD.filled_circle(120, 15, 4, RED);
      wait(0.1);
      pb1 = readPB1(pb1);
    }

    if (pb1 == 0)
      break;

    for (int i = 0; i < 4; i++)
    {
      uLCD.filled_circle(120, 15, 4, BLACK);
      wait(0.1);
      pb1 = readPB1(pb1);
    }
  }
}

void speech(const char *line1, const char *line2)
{
  draw_speech_bubble();
  draw_speech_line(line1, TOP);
  draw_speech_line(line2, BOTTOM);
  speech_bubble_wait();
  erase_speech_bubble();
}

void long_speech(const char *lines[], int n)
{
}
