#include "mbed.h"   //头文件
#include "stdint.h"
#include <VL6180x.h>
#define VL6180X_ADDRESS 0x29
#include "platform/mbed_thread.h"
#define BLINKING_RATE_MS 
VL6180xIdentification identification;
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor(D3, D6, VL6180X_ADDRESS<<1);//距离传感器
I2C i2c(I2C_SDA, I2C_SCL);//通过I2C来定义使用的I²C接口,如果没有特殊说明，那么就是默认调用SCL1和SDA1，
//也就是D14(SDA)和D15(SCL)接口
Serial pc(USBTX, USBRX);// 
//Serial pc(D8, D2); //这里是调用串口的命令，USBTX和USBRX指明了是通过USB先进行串口连接

int sensor_addr = 41 << 1;//I²C调用时需要指明地址，这个可以在淘宝卖家给的传感器手册中获取

DigitalOut green(LED1);
DigitalOut sw0(PA_0);
DigitalOut sw1(PA_1);


void color_read()
{
    //打开颜色传感器
    int r,g,b;
    green = 1; // off
    pc.baud(9600);
    // Connect to the Color sensor and verify whether we connected to the correct sensor.

    i2c.frequency(100000);

    char id_regval[1] = {146};
    char data[1] = {0};
    i2c.write(sensor_addr,id_regval,1, true);
    i2c.read(sensor_addr,data,1,false);

    if (data[0]==68) {
        green = 0;
        wait_us(2000000);
        green = 1;
    } else {
        green = 1;
    }

    // Initialize color sensor

    char timing_register[2] = {129,0};
    i2c.write(sensor_addr,timing_register,2,false);

    char control_register[2] = {143,0};
    i2c.write(sensor_addr,control_register,2,false);

    char enable_register[2] = {128,3};
    i2c.write(sensor_addr,enable_register,2,false);

    // Read data from color sensor (Clear/Red/Green/Blue)

//    while (true) {
    char clear_reg[1] = {148};
    char clear_data[2] = {0,0};
    i2c.write(sensor_addr,clear_reg,1, true);
    i2c.read(sensor_addr,clear_data,2, false);

    int clear_value = ((int)clear_data[1] << 8) | clear_data[0];

    char red_reg[1] = {150};
    char red_data[2] = {0,0};
    i2c.write(sensor_addr,red_reg,1, true);
    i2c.read(sensor_addr,red_data,2, false);

    int red_value = ((int)red_data[1] << 8) | red_data[0];

    char green_reg[1] = {152};
    char green_data[2] = {0,0};
    i2c.write(sensor_addr,green_reg,1, true);
    i2c.read(sensor_addr,green_data,2, false);

    int green_value = ((int)green_data[1] << 8) | green_data[0];

    char blue_reg[1] = {154};
    char blue_data[2] = {0,0};
    i2c.write(sensor_addr,blue_reg,1, true);
    i2c.read(sensor_addr,blue_data,2, false);

    int blue_value = ((int)blue_data[1] << 8) | blue_data[0];

    // print sensor readings

    pc.printf("Clear (%d), Red (%d), Green (%d), Blue (%d) \n", clear_value, red_value, green_value, blue_value);
    wait_us(500000);
 
    //颜色传感器显示数据
    r = red_value;
    g = green_value;
    b = blue_value;
//         pc.printf("R %d G %d B %d\n ",r,g,b);
    if (r > g*1.3 && r > b*1.3) {
    //   pc.printf("1");
    } else if (g > r*1.3 && g > b*1.3) {
    //  pc.printf("2");
    }  
    else if (b > r*1.3 && b > g*1.3) {
    //   pc.printf("3");
     }  

    wait_us(10000);
//   
}
void distance_read()
{
    uint8_t retaddr;
    pc.baud(9600);
    wait_us(1000); // delay .1s
    sensor.getIdentification(&identification); // Retrieve manufacture info from device memory
    if(sensor.VL6180xInit() != 0) {
        //printf("FAILED TO INITALIZE\n"); //Initialize device and check for errors
        static bool t=true;
        if(t){
        pc.printf(" far ");
        t=false;
        }
        else{
        pc.printf(" near ");
        t=true;
        }
    };

    sensor.VL6180xDefautSettings(); //Load default settings to get started.

    wait_us(10000);
    retaddr=sensor.changeAddress(0x29,0x27);
    sensor.getIdentification(&identification); // Retrieve manufacture info from device memory

    wait_us(10000);
    retaddr=sensor.changeAddress(0x27,0x29);
    sensor.getIdentification(&identification); // Retrieve manufacture info from device memory

//    while(1) {


    //Get Distance and report in mm
if(sensor.getDistance() < 100){
  //  pc.printf("a");}else pc.printf("b");

    wait_us(50000);

    }

}

int main()//通信逻辑
{
   
        pc.format(8,SerialBase::Odd,1);
        pc.baud(9600);
        pc.printf("start\n");
        color_read();
        distance_read();
    while (1) {
    
        char c=pc.getc();
        
        //wait_us(1000);
            if(c == 'm'){
             color_read();
             distance_read();
           }
             else if((c == 'a')||(c == 'x')){
             sw0=0,sw1=1;
            }
            else if((c == 'b')||(c == 'y')){
             sw0=1,sw1=0;
            }
            else if((c == 'c')||(c == 'z')){
             sw0=1,sw1=1;
            }
            //else if((c != 'a')||(c != 'x')||(c != 'b')||(c != 'y')||(c != 'c')||(c != 'z')){
             //sw0=0,sw1=0;
             //}
              else if(c == 'n'){
             distance_read();
            }
            }

    
}