#include "mbed.h"
#include "globals.h"
#include "Zombie.h"
#include "Player.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "microphone.h"
#include "rtos.h"

void playSound(char * wav);
void noiseThread(void const* name);

// Global Objects
AnalogOut Speaker(p18);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card and filesystem (mosi, miso, sck, cs)
wave_player waver(&Speaker);
uLCD_4DGL uLCD(p28,p27,p30);
microphone mic(p16);
DigitalOut myled(LED1);
AnalogIn ir(p20);
Player p;
Timer timer;

Zombie * zombies = new Zombie[4];
Zombie * z;
float noise;
bool gameover = false;

void small_explosion(int, int);
void drawZombies();
void checkCollisions();
void eraseZombies();
void updateZombies();
void killFirstZombie(bool);
int ammo = 20;
int score = 0;
int jj = 5;
int jumpcounter = jj;
Mutex lcd_mutex;



int main() {
    Thread t1(noiseThread);
    
    //locals
    //int tick,tock = 0;
    int start = 1;
    bool ready,jump = false;
    float irRead;
    timer.start();
    
    
    start = 1;
    if(start == 1){
        uLCD.text_string("", 0, 0, FONT_7X8, WHITE);
        uLCD.text_width(2);
        uLCD.text_height(2); 
        uLCD.printf("WORLD WAR \nZOMBIES!\n\n\n");
        wait(1);
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.printf("\n\nTo fire, place \nhand in front \nof IR, to jump\nsay jump in\nthe mic.");
        wait(5);
        uLCD.cls();
        uLCD.text_string("", 0, 0, FONT_7X8, RED);
        uLCD.printf("To begin the\ngame, make a\nnoise near the\nmic!"); 
        while(!ready){
            noise = int(abs((mic - (0.67/3.3)))*500.0);
            if(noise>3){
                ready = true;   
                uLCD.cls(); 
                noise = 0;
            }
        }//while
    }//if
    
    //Zombie z1,z2,z3,z4;
    for (int i = 1; i < 4; i++)
    {
        zombies[i].posX = zombies[i-1].posX + 45;
    }
    float fmic = .67/3.3;
    float pmic = fmic;
    p.draw();
    while(!gameover){
        uLCD.locate(0,0);
        uLCD.printf("Ammo: %d\nScore: %d\n", p.ammo, killed);
        pmic = fmic;
        fmic = (abs(mic - (0.67/3.3)))*500.0;
       // uLCD.printf("mic: %f", fmic);
        //drawZombies();
        checkCollisions();
        //eraseZombies();
        updateZombies();

        irRead = ir;
        irRead -= 1;
        irRead *= -1;
        
        jump = jump || fmic-pmic > 1.5;

        if(jump && jumpcounter > 0){
            if (jumpcounter == jj)
            {
                p.erase();
                p.posY = 127-18;
                p.draw();
             }
               jumpcounter--;
        }// jump
        else if (jumpcounter == 0)
        {
            p.erase();
            p.posY = 127;
            jumpcounter = jj;
            jump = false;
            p.draw();
        }

      //  p.draw();

        wait(0.1);
        
        //player input to shoot zombie
        if(irRead < 0.5){
            //check collision with zombies if there is ammo
            if(p.ammo>0){
                //shoot
                p.ammo -=1;
                uLCD.filled_rectangle(0, 0,127,127,WHITE);
                
                //if zombie on screen, kill front most
                // function finds first zombie, kill it, increment kill counter
                killFirstZombie(jump);


                uLCD.filled_rectangle(0, 0,127,127,BLACK);  
                 p.draw();
            }
        }
            
        wait(1/10000);
    }//while not gameover
    uLCD.cls();
    
                        small_explosion(115, 119);
                        small_explosion(38, 77);
                        small_explosion(66, 39);
                        small_explosion(33, 50);
                        small_explosion(72, 60);
                        small_explosion(8, 57);
                        small_explosion(30, 80);
                        small_explosion(46, 48);
                        small_explosion(76, 44);
                        small_explosion(49, 101);
    small_explosion(p.posX,p.posY-5);
        uLCD.text_string("", 0, 0, FONT_7X8, WHITE);
        uLCD.text_width(2);
        uLCD.text_height(2); 
        uLCD.printf("GAME OVER \nScore: %d\n\n\n", killed);
}//main

//plays a wav file from sd card
void playSound(char * wav)
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    if(wave_file == NULL){
        uLCD.locate(9,0);
        uLCD.printf("ERROR_SD");
        return;
    }
    
    // play wav file
    waver.play(wave_file);
    
    fclose(wave_file);
    return;
}//playsound

void noiseThread(void const* name){
    
    //Thread::wait(2);
    while(1) playSound("/sd/wavfiles/titlemusic.wav");
    //{
    //noise = (abs((mic - (0.67/3.3)))*500.0);
    //Use an 8kHz audio sample rate (phone quality audio);
//    Thread::wait(1.0/8000.0);
    //}
}//noisethread


// this function draws all the zombies on the screen
void drawZombies()
{
    for (int i = 0; i < 4; i++)
    {
        z = &zombies[i];
        if ((*z).alive && (*z).posX <= 127)
        {
            (*z).draw();
        }
    }
}

void checkCollisions()
{
    for (int i = 0; i < 4; i++)
    {
        z = &zombies[i];
        int x1 = p.posX;
        int x2 = p.posX + 10;
        int y = p.posY;
        if (((*z).posX-12 >= x1 && (*z).posX-12 <= x2) && (y == (*z).posY))
        {
            gameover = true;
        }
    }
}

void eraseZombies()
{
    for (int i = 0; i < 4; i++)
    {
        z = &zombies[i];
        if ((*z).alive && (*z).posX <= 127)
        {
            (*z).erase();
        }
    }
}

void updateZombies()
{
    for (int i = 0; i < 4; i++)
    {
        z = &zombies[i];
        if ((*z).alive)
        {
            (*z).move();
            if ((*z).posX <= 5)
            {
                z->kill();
                z->erase();
            }
        }
    }
}

void killFirstZombie(bool jump)
{
    int first = 0;
    int last = 0;
    int x = 128;
    int x2 = 128;
    // find first zombie
    for (int i = 0; i < 4; i++)
    {
        z = &zombies[i];
        if ((*z).posX < x && z->alive)
        {
            first = i;
            x = (*z).posX;
        }
        else if ((*z).posX > x2 && (*z).alive)
        {
            last = i;
            x2 = (*z).posX;
        }
    }
    // kill first zombie
    z = &zombies[first];
    if (z->alive)
    {
        z->kill();
        if (jump) killed++;
        z->erase();
        small_explosion(x, 125);
        z->posX = x2 + 45;
        z->alive = true;
    }
}

/*
* This makes explosion
*/
void small_explosion(int x, int y) {
    uLCD.filled_circle(x, y, 2, 0xFF22BB);
    uLCD.filled_circle(x, y, 1, 0);
    uLCD.filled_circle(x, y, 3, 0xFF22BB);
    uLCD.filled_circle(x, y, 1, 0);
    uLCD.filled_circle(x, y, 4, 0xFF22BB);
    uLCD.filled_circle(x, y, 2, 0);
    uLCD.filled_circle(x, y, 5, 0xFF22BB);
    uLCD.filled_circle(x, y, 3, 0);
    uLCD.filled_circle(x, y, 6, 0xFF22BB);
    uLCD.filled_circle(x, y, 4, 0);
    uLCD.filled_circle(x, y, 7, 0xFF22BB);
    uLCD.filled_circle(x, y, 5, 0);
    uLCD.filled_circle(x, y, 7, 0);
}