#include "mbed.h"
#include "globals.h"
#include "Player.h"

#ifndef ZOMBIE_H
#define ZOMBIE_H

extern uLCD_4DGL uLCD;

int killed = 0;

class Zombie
{
public:
    static const int WIDTH = 5;
    static const int HEIGHT = 10;
    int posX, posY;
    bool alive;
    
    Zombie()
    {
        posX = 127+12;
        posY = 127;
        alive = true;
    }
    
    void draw()
    {
        uLCD.filled_rectangle(posX-10, posY-13, posX-2, posY-16, GREEN);//head
        uLCD.filled_rectangle(posX-12, posY-13, posX-10, posY-7, GREEN);//left arm
        uLCD.filled_rectangle(posX-2, posY-13, posX, posY-7, GREEN);//right arm
        uLCD.filled_rectangle(posX-10, posY-7, posX-2, posY-13, 0x895300);//body
        uLCD.filled_rectangle(posX-10, posY-7, posX-2, posY-2, BLUE);//legs
        uLCD.filled_rectangle(posX-12, posY, posX, posY-2, 0x895300);//foot
    }
    
    void erase()
    {
        uLCD.filled_rectangle(posX-12, posY, posX, posY-17, BLACK);
    }
    
    bool collision(Player *p){
           if(posX == p->posX && posY == p->posY){
               return true;
            }//if
            return false;
    }

    void kill()
    {
        alive = false;
        killed++;
    }

    void move()
    {
        erase();
        posX-=7;
        draw();
        //uLCD.filled_rectangle(posX, posY, posX+WIDTH, posY-HEIGHT, GREEN);
        //uLCD.filled_rectangle(posX+3+WIDTH, posY, posX+WIDTH+3+WIDTH, posY-HEIGHT, BLACK);
    }
    
    //reset position, never more than 4 zombies
    void hit(){
        
    }
};

#endif