#include "mbed.h"
#include "TCPSocket.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

#define WIFI_IDW0XX1    2
#define MQTTCLIENT_QOS2 1

#define RELAY_TIMEOUT 1

#define DEVICE_MAC "1f00000001000000"
#define SOFTWARE_VERSION "0.9.0"
#define BROKER_URL "ec2-3-0-92-18.ap-southeast-1.compute.amazonaws.com"
#define BROKER_PORT 1883

#if (defined(TARGET_DISCO_L475VG_IOT01A) || defined(TARGET_DISCO_F413ZH))
#include "ISM43362Interface.h"

//ISM43362Interface _wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO, MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET, MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);
ISM43362Interface _wifi(false);
//
//#else // External WiFi modules
//
//#if MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
//#include "SpwfSAInterface.h"
//SpwfSAInterface _wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
//
//#endif // MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1

#endif

//WiFi LED region

#define WIFI_LED_ON     {_wifiLed.output(); _wifiLed = 1;_isWifiLedOn = 1;}
#define WIFI_LED_OFF    {_wifiLed.input(); _isWifiLedOn = 0;}

DigitalOut _pirSensorLed(LED1);
DigitalOut _relayLed(LED2);
DigitalInOut _wifiLed(LED3);

DigitalOut _relay1(D7);

InterruptIn _motionTrigger(D2);

Thread _dioManagerThread;
Thread _wifiManagerThread;
Thread _mqttClientThread;

int _currentRelayTimeout = RELAY_TIMEOUT;

typedef enum ServerConnectivity
{
    Disconnected,
    Connected
}ServerConnectivity;

ServerConnectivity _brokerConnection;
ServerConnectivity _pelionConnection;
 
Timer _resetRelayTimer;

bool _isRelayTriggered = false;
bool _isWifiConnected = false;

int _isWifiLedOn = 0;

MQTT::Client<MQTTNetwork, Countdown>* _mqttClient;

void OnRelay()
{
    //_relayLed = 1;
    _relay1 = 1;
    _isRelayTriggered = true;
}

void OffRelay()
{
    if(!_pirSensorLed)
    {
        //_relayLed = 0;
        _relay1 = 0;
        _isRelayTriggered = false;
        _resetRelayTimer.stop();
    }
    else
    {
        _resetRelayTimer.reset();
    }
}

void OnTrigger()
{
    _pirSensorLed = 1;
    _resetRelayTimer.reset();
    
    if(!_isRelayTriggered)
    {
        OnRelay();
        _resetRelayTimer.start();
    }
}

void OffTrigger()
{
    _pirSensorLed = 0; //When no more motion trigger, off the PIR LED
}

void HandlePIR()
{
    _motionTrigger.rise(&OnTrigger); 
    _motionTrigger.fall(&OffTrigger);
    
    while(true)
    {
        if(_isRelayTriggered) //If relay is triggering
        {
            if(_resetRelayTimer.read() > _currentRelayTimeout) //Read Timer, if timer read above target time
            {                
                OffRelay(); //Turn off the relay
            }
        }
        thread_sleep_for(500);
    }
}

int arrivedcount = 0;

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;    
    char* payload = (char*)message.payload;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, payload);
    arrivedcount++;
    
    MQTT::Message newMessage;
        // QoS 0
    char buf[100];
    sprintf(buf, "Bello From another side!  QoS 0 newMessage from app version %s\r\n", SOFTWARE_VERSION);
    newMessage.qos = MQTT::QOS0;
    newMessage.retained = false;
    newMessage.dup = false;
    newMessage.payload = (void*)buf;
    newMessage.payloadlen = strlen(buf)+1;
    _mqttClient->publish("testing123", newMessage);

}

void ConnectBroker(NetworkInterface *net)
{
    MQTTNetwork mqttNetwork(net);
    char* topic = "testing123";

    MQTT::Client<MQTTNetwork, Countdown> client (mqttNetwork);
    
    _mqttClient = &client;
    
    int rc = mqttNetwork.connect(BROKER_URL, BROKER_PORT);
    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);
        
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = DEVICE_MAC;
    data.username.cstring = DEVICE_MAC;
    data.password.cstring = DEVICE_MAC;
    
    if ((rc = _mqttClient->connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    if ((rc = _mqttClient->subscribe(topic, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);

    MQTT::Message message;
    
    // QoS 0
    char buf[100];
    sprintf(buf, "Hello World!  QoS 0 message from app version %s\r\n", SOFTWARE_VERSION);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = _mqttClient->publish(topic, message);
    while (arrivedcount < 1)
        _mqttClient->yield(100);

    // QoS 1
    sprintf(buf, "Hello World!  QoS 1 message from app version %s\r\n", SOFTWARE_VERSION);
    message.qos = MQTT::QOS1;
    message.payloadlen = strlen(buf)+1;
    rc = _mqttClient->publish(topic, message);
    while (arrivedcount < 2)
        _mqttClient->yield(100);

    // QoS 2
    sprintf(buf, "Hello World!  QoS 2 message from app version %s\r\n", SOFTWARE_VERSION);
    message.qos = MQTT::QOS2;
    message.payloadlen = strlen(buf)+1;
    rc = _mqttClient->publish(topic, message);

    while (arrivedcount < 3)
        _mqttClient->yield(100);

    while(true)
    {
        _mqttClient->yield(100);
    }
}

void ConnectWifi()
{   
    _wifi.disconnect();
    _wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    //int ret = 0;
//    do
//    {
//        ret = _wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
//        if(ret != 0)
//        {
//            thread_sleep_for(500);
//        }
//    }while(ret != 0);
//       
}

void status_callback(nsapi_event_t status, intptr_t param)
{   
    if (status == NSAPI_EVENT_CONNECTION_STATUS_CHANGE) {
        switch(param) {
            case NSAPI_STATUS_GLOBAL_UP:
            {
                _isWifiConnected = true;
                _currentRelayTimeout = 10; //ZXLIM - Assume connected to broker and control by broker
                _mqttClientThread.start(callback(ConnectBroker,&_wifi));
                WIFI_LED_ON;
                break;
            }
            default:
            {
                _isWifiConnected = false; //ZXLIM - Ignore connected LAN 1st.
                _currentRelayTimeout = 1;
                WIFI_LED_OFF;
                break;
            }
        }
    }
}

int main()
{
    
    _dioManagerThread.start(callback(HandlePIR));    
    _wifi.attach(&status_callback);
    _wifi.set_blocking(false);
    _wifiManagerThread.start(callback(ConnectWifi));
    
    while(true)
    {
        while(!_isWifiConnected)
        {
            if(!_isWifiLedOn)
            {
                WIFI_LED_ON;
            }
            else
            {
                WIFI_LED_OFF;
            }            
            thread_sleep_for(100);
        }      
        thread_sleep_for(500);
    }
}