/**
 * @defgroup sensor_control Sensor Control API
 * @{
 */ 

#include "sensor_driver.h"
//#include "mbed-trace/mbed_trace.h"
//#include "src/SensorProfile/sensor_profile.h"
#include "src/DatastructConversion/conversions.h"
//#include "src/TimeEngine/time_engine.h"
//#include "src/TraceManager/trace_manager.h"
//#include "src/TraceManager/trace_macro.h"

//#define TRACE_GROUP  "SensorDriver"

/* General Functions for type conversions */

std::string SensorDriver::ConvertSerialNumber(uint8_t sn_arr[])
{
    std::string sn_str = "";
    for (int i = 0; i < sizeof(sn_arr); i++)
    {
        std::string str = IntToHex(sn_arr[i]);
        sn_str.append(str);
    }
    return sn_str;
}


std::string SensorDriver::ConvertDataToString(float data)
{
    char buf[32];
    std::string data_str = DoubleToChar(buf, data, 2);
    return data_str;
}


int SensorDriver::ValidateData(float data, float data_min, float data_max)
{
    if (data > data_max | data < data_min) 
        {
            return SENSOR_DATAOOR;
        }
    else return SENSOR_DATAOK;
}


void SensorDriver::SendSensorEmTrace(int err, std::string trace_string)
{
    if (err == SENSOR_DCN)
    {
//        EmTrace(trace_level[WARN], trace_name[P1_DISCONN], RtcTimeNow()); // trace macro too specific to port 
        pc.printf("Warning: Sensor Disconnect\r\n");
    }

    if (err == SENSOR_CN)
    {
//        EmTrace(trace_level[INFO], trace_name[P1_CONN], RtcTimeNow()); // trace macro too specific to port
        pc.printf("Info: Sensor Connect\r\n");
    }

    if (err == SENSOR_DATAERR)
    {
//        EmTrace(trace_level[WARN], trace_name[SEN_DATA_NOT_RDY], RtcTimeNow()); // trace macro not specific to port
        pc.printf("Warning: Sensor Data Error\r\n");
    }

    if (err == SENSOR_DATAOOR)
    {
//        EmTrace(trace_level[WARN], trace_string, RtcTimeNow()); 
        pc.printf("Warning: Sensor Data Out of Range\r\n");
    }

    return;
}

/** @}*/
