#include <string>
#include "mbed.h"
#include "sps30.h"

#define SDA0                    D14 //PTE25
#define SCL0                    D15 //PTE24
#define LEDON                   0
#define LEDOFF                  1

using namespace std;

Serial pc(SERIAL_TX, SERIAL_RX);

//sps30 sps(SDA1, SCL1, 100000);                 //Microchip real time clock (set as 400kHz)
DigitalOut myled(LED1);

//-----------------------------------------------------------------------------
// initial splash display

void initSplash() {
    pc.printf("\r\n\r\n");
    pc.printf("-----------------------------------------------------------------------------\r\n");
}

//-----------------------------------------------------------------------------
// initial the scd30
/*
void initSPS30() {
    pc.printf("Initializing SPS30...\r\n");
    uint8_t dbg = sps.SoftReset();
    if (dbg != sps30::SPSnoERROR) pc.printf("No ack \r\n");
    wait_ms(2000);
    sps.GetSerialNumber();
    pc.printf(" - SPS30 s/n ascii: ");
    for(int i = 0; i < sizeof(sps.sn); i++) 
    {
        pc.printf("%c", sps.sn[i]);
    }
    pc.printf("\r\n");
    sps.GetArticleCode();
    pc.printf(" - SPS30 article code ascii: ");
    for(int i = 0; i < sizeof(sps.acode); i++) 
    {
        pc.printf("%d", sps.acode[i]);
    }
    pc.printf("\r\n");
    sps.SetAutoCleanInterval();
    pc.printf(" - SPS30 auto clean interval: %d", sps.clean_interval_i);
    pc.printf("\r\n");

    sps.StartMeasurement();
   // sps.startFanClean();
//    pc.printf(" - SPS30 start manual clean \r\n");
    
}
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------



int main()
{
    myled = LEDOFF;
    pc.baud(9600);
    wait_ms(200);
    initSplash();

    Sps30 sps(SDA2, SCL2, 100000);
    sps.InitSensor();
    wait(1);
    pc.printf("Serial Number: %s \r\n", sps.sensor_serial);
    
    int count = 0;
    pc.printf("Ready...\r\n");
    pc.printf(" count |       MASS CONCENTRATION (ug/m3)       |           NUMBER CONCENTRATION (#/cm3)           | Typical Particle Size \r\n");
    pc.printf("       |  PM1.0  |  PM2.5  |  PM4.0  |  PM10.0  |  PM0.5  |  PM1.0  |  PM2.5  |  PM4.0  |  PM10.0  |         (um)          \r\n");
    pc.printf("---------------------------------------------------------------------------------------------------------------------------\r\n");
    while(1)
    {
        myled = !myled;
        wait_ms(250);
        int ret = sps.PollSensor();
        if (ret == SensorDriver::SENSOR_DATAOK)
        {
            pc.printf(" %5d |", count);
            for (int i = 0; i < sps.sensor_data.size(); i++)
            {
                pc.printf("   %s   |", sps.sensor_data[i].second);
            }
            pc.printf("\r\n");
            count++;
        }
        
        /*
        sps.GetReadyStatus();
        uint16_t redy = sps.ready;
        if(redy == sps30::SPSisReady) {
            uint8_t crcc = sps.ReadMeasurement();
            count++;
            if(crcc != sps30::SPSnoERROR) pc.printf("ERROR: %d\r\n", crcc);
            else pc.printf(" %5d | %7.3f | %7.3f |  %7.3f | %7.3f | %7.3f | %7.3f | %7.3f | %7.3f |  %7.3f |       %7.3f \r\n", \
                            count, sps.mass_1p0_f, sps.mass_2p5_f, sps.mass_4p0_f, sps.mass_10p0_f, sps.num_0p5_f, \
                            sps.num_1p0_f, sps.num_2p5_f, sps.num_4p0_f, sps.num_10p0_f, sps.typ_pm_size_f);
        }
        */
//        pc.printf("breakpoint 2");
//        sps.sensor_data.clear();
        wait(5);
    }
}
