#include "mbed.h"
#include "mbed_bme680.h"

#define I2C_SDA D14
#define I2C_SCL D15

I2C i2c(I2C_SDA, I2C_SCL);  // Used inside the BME680 Mbed Lib.

BME680 bme680(0xEE);

int main()
{    
    if (!bme680.begin()) {
        printf("BME680 Begin failed \r\n");
        return 1;
    }

    while (true) {
        if (bme680.performReading())
        {
            printf("\r\nTemperature  Humidity  Pressure    VOC\r\n"
                   "    degC        %%        hPa      KOhms\r\n"
                   "------------------------------------------\r\n");
            printf("   %.2f      ", bme680.getTemperature());
            printf("%.2f    ", bme680.getHumidity());
            printf("%.2f    ", bme680.getPressure() / 100.0);
            printf("%0.2f\r\n", bme680.getGasResistance() / 1000.0);
        }

        thread_sleep_for(1000);
    }
}