#include "mbed.h" 
#include "BufferedSerial.h"

Serial pc(USBTX, USBRX,115200); 
Serial RS485(D1,D0); // Tx, Rx
DigitalOut ho(D2);

typedef uint8_t byte;

//byte data[9] = {0x01,0x04,0x00,0x48,0x00,0x02,0xf1,0xdd};//your data
byte enable[9] = {0x01,0x06,0x20,0x0E,0x00,0x08,0xE2,0x0F};//your data
byte run[9] = {0x01,0x06,0x20,0x89,0x00,0x0A,0xD3,0xE7};//your data
byte stop[9] = {0x01,0x06,0x20,0x0E,0x00,0x07,0xA2,0x0B};//your data
 
int main()
{
    printf("Main\n");
    RS485.baud(115200);
    pc.baud(115200);
    while(1) {
        RS485.baud(115200);
        pc.printf("Starting\n");
        ho = 1;                  // 3.3V output from digital out pin
        
        for (int i=0; i<(sizeof(enable)-1);i++)
        {
            RS485.putc(enable[i]);    
        }

        wait_ms(2000);         // Silent interval
        
        for (int i=0; i<(sizeof(run)-1);i++)
        {
            RS485.putc(run[i]);    
        }

        wait_ms(5000);         // Silent interval
        
        for (int i=0; i<(sizeof(stop)-1);i++)
        {
            RS485.putc(stop[i]);    
        }

        wait_ms(50);         // Silent interval
        
        pc.printf("Getting data\n");
        
        ho = 0;
        pc.printf("The RS485 value %d\n",RS485.readable());
        
        char buffer[50];
        RS485.gets(buffer, 9);
        
        for (int count = 0; count < 8; count++) {
                pc.printf("%02hhX", buffer[count]);
        }
        pc.printf("\n");
        pc.printf("Done\n");
        wait_ms(1000);
    }
} 