#include "mbed.h"
#include <ros.h>
#include <std_msgs/Int16.h>
#include "VEML7700.h"

#ifndef MSU_VEML7700_I2C_ADDRESS
#define MSU_VEML7700_I2C_ADDRESS 0x10
#endif

#define PIN_SCL  D15
#define PIN_SDA  D14

ros::NodeHandle  nh;

std_msgs::Int16 data;
ros::Publisher ALS("ALS", &data);

VEML7700 *veml7700 = 0 ;

int main() {
    uint16_t als ;
    
    veml7700 = new VEML7700(PIN_SDA, PIN_SCL, MSU_VEML7700_I2C_ADDRESS) ; 
    veml7700->setALSConf(0x0000) ;
    veml7700->setPowerSaving(0x0000) ;
    
    nh.initNode();
    nh.advertise(ALS);
    
    while (1) { //creates an eternal loop
    
        als = veml7700->getALS();
        
        data.data = als;
        ALS.publish( &data );
        
        nh.spinOnce();
        wait_ms(1000);
    }
}
