#include <ros.h>
#include <std_msgs/Float32.h>
#include <std_msgs/String.h>
#include "SHARPIR.h"


ros::NodeHandle  nh;

std_msgs::Float32 data;
ros::Publisher sharpir("sharpir", &data);

SHARPIR Sensor(A0); 


int main() {
    float DistanceCM;
    
    nh.initNode();
    nh.advertise(sharpir);
    
    while (1) { //creates an eternal loop
    
        DistanceCM=Sensor.cm();  
        //sprintf (buffer, "%f", DistanceCM);
        
        data.data = DistanceCM;
        sharpir.publish( &data );
        
        nh.spinOnce();
        wait_ms(1000);
    }
}
