#include "mbed.h"
#include <ros.h>
#include <std_msgs/String.h>
#include "hcsr04.h"

ros::NodeHandle  nh;

std_msgs::String data;
ros::Publisher ultrasonic("ultrasonic", &data);

//D12 TRIGGER D11 ECHO
HCSR04 sensor(D8, D9);

int main() {
    char buffer[50];

    nh.initNode();
    nh.advertise(ultrasonic);

    while (1) { //creates an eternal loop

        long distance = sensor.distance();
        sprintf (buffer, "%d", distance);

        data.data = buffer;
        ultrasonic.publish( &data );

        nh.spinOnce();
        wait_ms(1000);
    }
}