#include "mbed.h"
#include <ros.h>
#include "std_msgs/String.h"
#include "mbed_bme680.h"

#define I2C_SDA D14
#define I2C_SCL D15

I2C i2c(I2C_SDA, I2C_SCL);  // Used inside the BME680 Mbed Lib.

BME680 bme680(0xEE);


ros::NodeHandle nh;

std_msgs::String msg;
ros::Publisher sensor_bme("sensor_bme", &msg);

int main() {
    
    if (!bme680.begin()) {
        printf("BME680 Begin failed \r\n");
        return 1;
    }
    nh.initNode();  
    nh.advertise(sensor_bme);

    while (1) { //creates an eternal loop
        char* buffer = (char*) malloc(sizeof(char) * 50);
        
        bme680.performReading();
        sprintf (buffer, "Temp: %0.2f degC,Humi: %0.2f %%,Pres: %0.2f hPa,VOC: %0.2f KOhms", bme680.getTemperature(),bme680.getHumidity(),(bme680.getPressure() / 100.0),(bme680.getGasResistance() / 1000.0));
        
        
        msg.data = buffer;
        sensor_bme.publish(&msg);
               
        nh.spinOnce();
        free(buffer);
        wait_ms(1000);

    }
}
