#include <ros.h>
#include <std_msgs/Float32.h>
#include <std_msgs/String.h>
#include <std_msgs/Int16.h>
#include "SHARPIR.h"
#include "hcsr04.h"
#include "VEML7700.h"
#include "mbed_bme680.h"

#ifndef MSU_VEML7700_I2C_ADDRESS
#define MSU_VEML7700_I2C_ADDRESS 0x10
#endif

#define PIN_SCL  D15
#define PIN_SDA  D14

//Sharp IR sensor analog pin defination
SHARPIR Sensor(A0); 

//Ultrasonic sensor pin defination
//D8 TRIGGER D9 ECHO
HCSR04 sensor(D8, D9);

// BME680 pin defination
I2C i2c(PIN_SDA, PIN_SCL);  
BME680 bme680(0xEE); //I2C address for BME680

ros::NodeHandle  nh;

//SharpIR publisher initialization
std_msgs::Float32 data_ir;
ros::Publisher sharpir("sharpir", &data_ir);

//Ultrasonic sensor publisher initialization
std_msgs::String data_ul;
ros::Publisher ultrasonic("ultrasonic", &data_ul);

//Ambient Light sensor publisher initialization
std_msgs::Int16 data_als;
ros::Publisher ALS("ALS", &data_als);

//BME680 publisher initialization
std_msgs::String msg;
ros::Publisher sensor_bme("sensor_bme", &msg);

VEML7700 *veml7700 = 0 ;

int main() {
    float DistanceCM; //Variable to store distance in CM from SharpIR sensor
    char buffer[50]; // buffer for Ultrasonic sensor values
    char buff_bme[50]; // buffer for bme690 sensor values
    
    //Initialization of Ambient light sensor
    uint16_t als ;
    veml7700 = new VEML7700(PIN_SDA, PIN_SCL, MSU_VEML7700_I2C_ADDRESS) ; 
    veml7700->setALSConf(0x0000) ;
    veml7700->setPowerSaving(0x0000) ;
    
    //Initalization of BME680
    if (!bme680.begin()) {
        printf("BME680 Begin failed \r\n");
        return 1;
    }
    
    //Initalizing and advertising topics
    nh.initNode();
    nh.advertise(sharpir); //SharpIR sensor
    nh.advertise(ultrasonic); //Ultrasonic Sensor
    nh.advertise(ALS); //Ambient Light Sensor
    nh.advertise(sensor_bme); //bme680 sensor
    
    while (1) { //creates an eternal loop
    
        DistanceCM=Sensor.cm(); //Reading SharpIR sensor value from analog pin
        wait_ms(500);
        
        long distance = sensor.distance(); //Reading ultrasonic sensor value
        sprintf (buffer, "%d", distance);  //converting value into string
        wait_ms(500);
        
        als = veml7700->getALS(); //Readinng ALS sensor value
        wait_ms(500);
        
        bme680.performReading(); //Reading bme680 value
        sprintf (buff_bme, "Temp: %0.2f degC,Humi: %0.2f %%,Pres: %0.2f hPa,VOC: %0.2f KOhms", bme680.getTemperature(),bme680.getHumidity(),(bme680.getPressure() / 100.0),(bme680.getGasResistance() / 1000.0));
        wait_ms(500);
        
        data_ir.data = DistanceCM;
        sharpir.publish( &data_ir );
        
        data_ul.data = buffer;
        ultrasonic.publish( &data_ul );
        
        data_als.data = als;
        ALS.publish( &data_als );
        
        msg.data = buffer;
        sensor_bme.publish(&msg);
        
        nh.spinOnce();
        wait_ms(1000);
    }
}
