#include "mbed.h"
#include "stm32469i_discovery.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "F469_GUI.hpp"
#include "math.h"

//#define TIME                              // Time for toggle the LED (seconds)
#define Num 20000
#define Resolucao   4095

Timeout timeout;                            // Create the Timeout object
Timeout timeout2;
Timeout timeout3;
Timeout timeout4;
Timeout timeout5;
Timeout timeout6;
DigitalOut ports[] = {(D0),(D1),(D2),(D3),(D4),(D5),(D6),(D7),(D8),(D9),(D10),(D11)};
AnalogIn analog_value(A0);
//DigitalOut toogle(D14);


//float h[50]={0.00013664,0.0031434,-0.0011824,-0.01819,0.0050009,0.03851,-0.0087039,-0.027769,0.0011091,-0.022893,0.014935,0.042351,-0.0081599,0.017305,-0.024729,-0.057635,0.017887,-0.021015,0.048111,0.090766,-0.038671,0.046058,-0.15008,-0.29325,0.34694,0.34694,-0.29325,-0.15008,0.046058,-0.038671,0.090766,0.048111,-0.021015,0.017887,-0.057635,-0.024729,0.017305,-0.0081599,0.042351,0.014935,-0.022893,0.0011091,-0.027769,-0.0087039,0.03851,0.0050009,-0.01819,-0.0011824,0.0031434,0.00013664
//};
float h[151]={ 0.00085858,-0.00042606,-0.0015497,0.0025922,-0.0012627,-0.0045709,0.0045298,0.0016832,-0.00021682,0.0032086,-0.005761,-0.001845,8.275e-05,-0.0026711,0.006908,0.0011507,0.0014115,0.0022169,-0.0076429,-0.00025806,-0.0040655,-0.0013819,0.0072834,-0.00032939,0.0073833,9.7708e-05,-0.0052098,7.8399e-05,-0.010456,0.0012451,0.0012081,0.0013649,0.0121,-0.0018408,0.0042649,-0.0038654,-0.011222,0.00072002,-0.010022,0.0065729,0.0072796,0.0027994,0.014384,-0.0079399,-0.00066081,-0.0085907,-0.015693,0.0060706,-0.0072193,0.015325,0.012945,0.00065311,0.014214,-0.020385,-0.0062987,-0.01286,-0.018089,0.020111,-0.0027722,0.029675,0.017308,-0.010075,0.011812,-0.048643,-0.011664,-0.015803,-0.018126,0.066211,0.0024952,0.0736,0.019681,-0.078652,0.0076586,-0.30679,-0.015847,0.58315,-0.015847,-0.30679,0.0076586,-0.078652,0.019681,0.0736,0.0024952,0.066211,-0.018126,-0.015803,-0.011664,-0.048643,0.011812,-0.010075,0.017308,0.029675,-0.0027722,0.020111,-0.018089,-0.01286,-0.0062987,-0.020385,0.014214,0.00065311,0.012945,0.015325,-0.0072193,0.0060706,-0.015693,-0.0085907,-0.00066081,-0.0079399,0.014384,0.0027994,0.0072796,0.0065729,-0.010022,0.00072002,-0.011222,-0.0038654,0.0042649,-0.0018408,0.0121,0.0013649,0.0012081,0.0012451,-0.010456,7.8399e-05,-0.0052098,9.7708e-05,0.0073833,-0.00032939,0.0072834,-0.0013819,-0.0040655,-0.00025806,-0.0076429,0.0022169,0.0014115,0.0011507,0.006908,-0.0026711,8.275e-05,-0.001845,-0.005761,0.0032086,-0.00021682,0.0016832,0.0045298,-0.0045709,-0.0012627,0.0025922,-0.0015497,-0.00042606,0.00085858
};
//float h[41]={ 0.0013777,-0.0041524,0.0044975,0.018256,-0.027017,-0.02849,0.036046,0.010033,0.011027,0.020938,-0.059537,-0.015841,-0.0016861,-0.017589,0.10377,0.017077,-0.0031668,0.016809,-0.31751,-0.017002,0.50469,-0.017002,-0.31751,0.016809,-0.0031668,0.017077,0.10377,-0.017589,-0.0016861,-0.015841,-0.059537,0.020938,0.011027,0.010033,0.036046,-0.02849,-0.027017,0.018256,0.0044975,-0.0041524,0.0013777
//};
char desligado=0;
int efeito=1;
int escolha_anterior=-1;
//1-Sem efeito
//2-Robo
//3-Reverb
//4-Chorus
//5-Distorcao
//6-Radio
int Numero_Amostras=50000;
int amostra_atual=0;
int reproducao_atual=0;
int chorus1_atual=0;
int chorus2_atual=0;
int chorus3_atual=0;
float TIME=0.000025,x;//20Khz
uint16_t Leitura_som[Num];
uint16_t Leitura_som_sub[Num];
uint16_t Reproducao_som[Num];
uint16_t aux_radio[Num];
uint16_t chorus1val[Num];
uint16_t chorus2val[Num];
uint16_t chorus3val[Num];


char configura=1;
const int NUMBER_BUTTONS = 7;   //Número de botões
const string STR1[NUMBER_BUTTONS] = {"OFF","Pass","Robo","Rev","Chor","Dist","Rad"};  //string que vai nos botões
    //cria botão na tela,(inicio em x, inicio em Y, largura do botão, altura do botão, número de botões
    //                    nome do botão,distãncia dos botões em x, distãncia dos botões em y, número de colunas,
    //                    número de colunas, número de linhas, fonte do texto, cor do texto, cores dos estados do botão)
ButtonGroup bGroup1(30, 90, 80, 80,  NUMBER_BUTTONS, STR1, 20, 20, 7, 1,Font24, LCD_COLOR_WHITE, 0xFF003538, 0xFFB70068, 0xFFFF7FFF);
Label bTouch(150, 280, Label::LEFT, Font24, LCD_COLOR_MAGENTA);


void Escolha(void);
void Captura_som(void);
void Reproduz_som(void);
void escreve_valor_digital_12bits(uint16_t valor);
void chorus1(void);
void chorus2(void);
void chorus3(void);




int main()
{  
    timeout3.attach(&Escolha, 0.01);
    timeout.attach(&Captura_som, TIME); // Set again the timer timeout for next iterations
    while (true)
    {
        
    }
}

void Captura_som()
{
    int i,j;
    float acc1,acc2;
    if(efeito!=6){
        Leitura_som[amostra_atual] = ((analog_value.read()*Resolucao));
        Reproducao_som[amostra_atual]=Leitura_som[amostra_atual];
        amostra_atual++;
        if(amostra_atual==Numero_Amostras){
            amostra_atual=0;
            if(efeito!=4)timeout2.attach(&Reproduz_som, TIME);
            }
            if(efeito==4)timeout2.attach(&Reproduz_som, TIME);
        
        if(desligado==0)timeout.attach(&Captura_som, TIME); // Set again the timer timeout for next iterations
    }
    else{
        timeout.attach(&Captura_som, TIME);
        acc1=0;
        for(j=0;j<151;j++){
                acc1=acc1+h[j]*Leitura_som[j];
            }
            
            escreve_valor_digital_12bits((uint16_t)acc1*3);
            i=0;
    while(i<151){
        Leitura_som[i]=Leitura_som[i+1];
        i++;
        }
    //for(i=0;i<50;i++) Leitura_som[i]=Leitura_som[i+1];
    Leitura_som[151] = ((analog_value.read()*Resolucao));
    //if(amostra_atual==Numero_Amostras)amostra_atual=0;
    }
}

void Reproduz_som()
{       
    if(efeito==5){
        if(Reproducao_som[reproducao_atual]>2000)Reproducao_som[reproducao_atual]=2000;
        }
    if(efeito==4){
        chorus1val[reproducao_atual]=Reproducao_som[reproducao_atual];
        if(reproducao_atual==(1000))timeout4.attach(&chorus1, TIME);
        }
    escreve_valor_digital_12bits((uint16_t)Reproducao_som[reproducao_atual]);
    reproducao_atual++;
    if(reproducao_atual==Numero_Amostras) reproducao_atual=0;
    else if(efeito==2)timeout2.attach(&Reproduz_som, TIME/200);
    //else if(efeito==6)timeout2.attach(&Reproduz_som, TIME);
    else timeout2.attach(&Reproduz_som, TIME);
    
}

void chorus1(void){
    if(efeito==4){
        if(chorus1_atual==2000)timeout5.attach(&chorus2, TIME);
        chorus2val[chorus1_atual]=chorus1val[chorus1_atual];
        escreve_valor_digital_12bits((uint16_t)chorus1val[chorus1_atual]);
        chorus1_atual++;
        if(chorus1_atual==Numero_Amostras)chorus1_atual=0;
        else timeout4.attach(&chorus1, TIME);
        }
    }
void chorus2(void){
    if(efeito==4){
        if(chorus2_atual==3000)timeout6.attach(&chorus3, TIME);
        chorus3val[chorus2_atual]=chorus2val[chorus2_atual];
        escreve_valor_digital_12bits((uint16_t)chorus2val[chorus2_atual]);
        chorus2_atual++;
        if(chorus2_atual==Numero_Amostras)chorus2_atual=0;
        else timeout5.attach(&chorus2, TIME);
        }
    }
void chorus3(void){
    if(efeito==4){
        escreve_valor_digital_12bits((uint16_t)chorus3val[chorus3_atual]);
        chorus3_atual++;
        if(chorus3_atual==Numero_Amostras)chorus3_atual=0;
        else timeout6.attach(&chorus3, TIME);
        }
    }


void escreve_valor_digital_12bits(uint16_t valor){
    int cont=0;
    for(cont=0;cont<12;cont++){
        ports[cont]=valor & (1<<cont);
    }
}

void Escolha(void){
    if (bGroup1.GetTouchedNumber(efeito));
    if(escolha_anterior!=efeito){
        escolha_anterior=efeito;
        amostra_atual=0;
        reproducao_atual=0;
    if(efeito==0){
        bTouch.Draw("OFF");
        desligado=1;
        }
    else if(efeito==1){
        bTouch.Draw("SEM EFEITO");
        Numero_Amostras=50;
        TIME=0.000025;
        }
    else if(efeito==2){
        bTouch.Draw("Efeito: ROBO");
        Numero_Amostras=50;
        TIME=0.000025;
        //TIME=0.0000005;
        }
    else if(efeito==3){
        bTouch.Draw("Efeito: REVERB");
        //Numero_Amostras=15000;
        //TIME=0.000025;
        TIME=0.000025;
        Numero_Amostras=8000;
        }
    else if(efeito==4){
        bTouch.Draw("Efeito: CHORUS");
        TIME=0.000025;
        Numero_Amostras=5000;
        }
    else if(efeito==5){
        bTouch.Draw("Efeito: DISTORCAO");
        TIME=0.000025;
        Numero_Amostras=50;
        }
    else if(efeito==6){
        bTouch.Draw("Efeito: RADIO");
        TIME=0.0001;
        Numero_Amostras=50;
        }
    if(efeito!=0){
        desligado=0;
        timeout.attach(&Captura_som, TIME);
        }
    }
    timeout3.attach(&Escolha, 1);
    
 }
 