//#include "mbed.h"
DigitalOut dat(PD_4);
DigitalOut clk(PD_5);
DigitalOut res(PD_6);
DigitalOut reg(PD_7);

//6903 102X64LCD
const unsigned char asc2[][6]={//8x6 Dots 32-126[0-94]
{0x00,0x3E,0x45,0x49,0x51,0x3E},//0
{0x00,0x00,0x21,0x7F,0x01,0x00},//1
{0x00,0x31,0x43,0x45,0x49,0x31},//2
{0x00,0x22,0x49,0x49,0x49,0x36},//3
{0x00,0x04,0x0C,0x14,0x7F,0x04},//4
{0x00,0x72,0x51,0x51,0x51,0x4E},//5-5
{0x00,0x3E,0x49,0x49,0x49,0x06},//6
{0x00,0x40,0x43,0x4C,0x50,0x60},//7
{0x00,0x36,0x49,0x49,0x49,0x36},//8
{0x00,0x30,0x48,0x48,0x48,0x3F},//9
{0x00,0x1F,0x24,0x64,0x24,0x1F},//A-10
{0x00,0x41,0x7F,0x49,0x49,0x36},//B
{0x00,0x3E,0x41,0x41,0x41,0x22},//C
{0x00,0x41,0x7F,0x41,0x41,0x3E},//D
{0x00,0x41,0x7F,0x49,0x49,0x63},//E
{0x00,0x41,0x7F,0x49,0x5C,0x60},//F-15
{0x00,0x3E,0x41,0x45,0x47,0x24},//G
{0x41,0x7F,0x08,0x08,0x08,0x7F},//H
{0x00,0x00,0x41,0x7F,0x41,0x00},//I
{0x00,0x42,0x41,0x7F,0x40,0x40},//J
{0x00,0x41,0x7F,0x59,0x24,0x43},//K-20
{0x00,0x40,0x7F,0x41,0x01,0x03},//L
{0x00,0x7F,0x20,0x1E,0x20,0x7F},//M
{0x00,0x7F,0x30,0x18,0x06,0x7F},//N
{0x00,0x3E,0x41,0x41,0x41,0x3E},//O
{0x00,0x41,0x7F,0x49,0x48,0x30},//P-25
{0x00,0x3E,0x41,0x47,0x42,0x3D},//Q
{0x00,0x41,0x7F,0x49,0x4C,0x33},//R
{0x00,0x32,0x49,0x49,0x49,0x26},//S
{0x00,0x60,0x41,0x7F,0x41,0x60},//T
{0x00,0x7E,0x01,0x01,0x01,0x7E},//U-30
{0x00,0x7C,0x02,0x01,0x02,0x7C},//V
{0x00,0x7C,0x03,0x3C,0x03,0x7C},//W
{0x00,0x43,0x24,0x18,0x24,0x43},//X
{0x00,0x60,0x18,0x07,0x18,0x60},//Y
{0x00,0x63,0x45,0x49,0x51,0x63},//Z-35
{0x00,0x00,0x00,0x01,0x00,0x00},//.
{0x00,0x14,0x14,0x14,0x14,0x14},//=
{0x00,0x08,0x08,0x3E,0x08,0x08},//+
{0x00,0x08,0x08,0x08,0x08,0x08},//-
{0x00,0x00,0x00,0x24,0x00,0x00},//:-40
};
//Write Plus
void wri(void){clk=0;clk=1;}
//使用SPI接口写数据到LCD,dt：写入的数据 command: 1-数据/0-命令
void b2l(unsigned char dt,unsigned char command){
 unsigned char i;
 reg=command;  
 for(i=0;i<8;i++){
  if(dt&0x80) dat=1;else dat=0;
  dt=dt<<1;    
  wri();
 }  
}
//名称: 设置坐标函数,参数：X：0－83 Y：0－5
void setXY(unsigned char X,unsigned char Y){
 b2l(0x40+Y,0);//column
 b2l(0x80+X,0);//row
}
//名称: LCD清屏函数
void lcdClear(void){
 unsigned char t,k;
 setXY(0,0);
 for(t=0;t<9;t++){for(k=0;k<102;k++){b2l(0x00,1);}}
}
//名称: 显示英文字符,参数：c：显示的字符在asc2表格中的位置
void c2l(unsigned char x,unsigned char y,unsigned char c){
 unsigned char line;
 setXY(x*6,y);    
 for(line=0;line<6;line++)b2l(asc2[c][line],1);
}
//名称: 6903LCD初始化函数
void lcdInit(void){
 wait(0.1);
 res=0;
 wait(0.5);
 res=1;
 wait(0.5);   
 b2l(0x25,0);//00100 PD=1dcOn|=0Dcoff V=0Up|=1Left H==1
 wait(0.05);
 b2l(0x15,0);//脉宽L000~111=1/6-1/7-1/8-1/9//14=1/7
 wait(0.05);
 b2l(0x94,0);//设置VOP值,约为8.96V
 wait(0.05);
 b2l(0x20,0);//PD=0,H=0,V=0
 b2l(0x0C,0);//LCD设置完成
 wait(0.5);
}
//Display ASCII Test
void dispAsc(void){
 int i,j,k=0;
 for(i=0;i<8;i++){
  for(j=0;j<17;j++){
   c2l(j,i,k);
   if(k>39){k=0;}else{k++;}
  }
 }
}
//END Files//

