#include "mbed.h"
#include "6903.h"

DigitalOut led1(PB_0);
DigitalOut led2(PB_7);
DigitalOut led3(PB_14);
AnalogIn adc0(PA_3);
AnalogIn adc1(PC_0);
AnalogIn adc2(PC_3);
AnalogIn adc3(PF_3);
PwmOut pwm0(PA_7);
PwmOut pwm1(PD_14);
PwmOut pwm2(PD_15);
//PwmOut pwm3(PF_13);
DigitalOut plusF12(PF_12);
Ticker tick;
InterruptIn plusInE9(PE_9);
InterruptIn plusInF15(PF_15);
DigitalIn inPutE12(PE_12);
DigitalIn inPutE14(PE_14);
DigitalIn inPutE15(PE_15);

uint16_t i=0,adcCount=0,adcTimes=64,pwmdir0=1,pwmdir1=1,pwmdir2=1,pe9,pf15;
float val0,val1,val2,val3,duty,dut0=0.01f,dut1=0.01f,dut2=0.01f,ddu0=0.01f,ddu1=0.02f,ddu2=0.03f;
uint32_t js,adcTemp;
int testTime=0,dispTime,pe12,pe14,pe15;

void tipInt(void){plusF12=1;wait(0.0002);plusF12=0;}//plus width=0.00001S
void PlusInE9(void){wait(0.0001f);if(PE_9)pe9++;}
void PlusInF15(void){wait(0.0001f);if(PF_15)pf15++;}
//Test leds
void testLed(void){
 if(testTime==0){led1=1;led3=0;testTime++;
 }else if(testTime==1){led2=1;led1=0;testTime++;
 }else if(testTime==2){led3=1;led2=0;testTime=0;}
}
//显示布局 6903
void dispBase(void){
 c2l(0,2,19);c2l(1,2,28);c2l(2,2,37);//JS=
 c2l(0,3,10);c2l(1,3,0);c2l(2,3,37);c2l(8,3,10);c2l(9,3,1);c2l(10,3,37);//A0=,A1=
 c2l(0,4,10);c2l(1,4,2);c2l(2,4,37);c2l(8,4,10);c2l(9,4,3);c2l(10,4,37);//A2=,A3=
 c2l(0,5,25);c2l(1,5,22);c2l(2,5,0);c2l(3,5,37);//PM0
 c2l(8,5,25);c2l(9,5,22);c2l(10,5,1);c2l(11,5,37);//PM1
 c2l(0,6,25);c2l(1,6,22);c2l(2,6,2);c2l(3,6,37);//PM2
 c2l(8,6,14);c2l(9,6,3);c2l(10,6,4);c2l(11,6,5);//P345
 c2l(0,7,25);c2l(1,7,14);c2l(2,7,9);c2l(3,7,37);//PE9
 c2l(8,7,25);c2l(9,7,15);c2l(10,7,1);c2l(11,7,5);c2l(12,7,37);//PF15
 //c2l(5,0,25);c2l(5,1,42);c2l(5,2,18);c2l(5,3,24);//PJ28
 //c2l(6,0,13);c2l(6,1,41);c2l(6,2,51);c2l(6,3,52);//dist
}
//Display Test Data 6903
void dispMes(void){
 c2l(3,2,(js/10000000)%10);c2l(4,2,(js/1000000)%10);c2l(5,2,(js/100000)%10);c2l(6,2,(js/10000)%10);
 c2l(7,2,(js/1000)%10);c2l(8,2,(js/100)%10);c2l(9,2,(js/10)%10);c2l(10,2,(js)%10);
 c2l(3,3,int(val0*10)%10);c2l(4,3,int(val0*100)%10);c2l(5,3,int(val0*1000)%10);c2l(6,3,int(val0*10000)%10);
 c2l(11,3,int(val1*10)%10);c2l(12,3,int(val1*100)%10);c2l(13,3,int(val1*1000)%10);c2l(14,3,int(val1*10000)%10);
 c2l(3,4,int(val2*10)%10);c2l(4,4,int(val2*100)%10);c2l(5,4,int(val2*1000)%10);c2l(6,4,int(val2*10000)%10);
 c2l(11,4,int(val3*10)%10);c2l(12,4,int(val3*100)%10);c2l(13,4,int(val3*1000)%10);c2l(14,4,int(val3*10000)%10);
 c2l(4,5,int(dut0*10)%10);c2l(5,5,int(dut0*100)%10);c2l(6,5,int(dut0*1000)%10);
 c2l(12,5,int(dut1*10)%10);c2l(13,5,int(dut1*100)%10);c2l(14,5,int(dut1*1000)%10);
 c2l(4,6,int(dut2*10)%10);c2l(5,6,int(dut2*100)%10);c2l(6,6,int(dut2*1000)%10);
 c2l(13,6,(inPutE12&1)%1);c2l(14,6,(inPutE14&1)%1);c2l(15,6,(inPutE15&1)%1);
 c2l(4,7,(pe9/100)%10);c2l(5,7,(pe9/10)%10);c2l(6,7,(pe9)%10);
 c2l(13,7,(pf15/100)%10);c2l(14,7,(pf15/10)%10);c2l(15,7,(pf15)%10);
 //c2l(6,5,int(dist/100)%10+16);c2l(6,6,int(dist/10)%10+16);c2l(6,7,int(dist)%10+16);c2l(6,8,14);c2l(6,9,int(dist*10)%10+16);c2l(6,10,int(dist*100)%10+16);
}
// main() runs in its own thread in the OS
int main(){
 pwm0.period(0.01);
 pwm1.period(0.02);
 pwm2.period(0.03);
 inPutE12.mode(PullNone);
 inPutE14.mode(PullNone);
 inPutE15.mode(PullNone);
 lcdInit();
 lcdClear();
 dispBase();
 tick.attach(&tipInt,0.005);
 plusInE9.rise(&PlusInE9);
 plusInF15.rise(&PlusInF15);
 while (true){
  js++;
  val0=adc0.read();
  val1=adc1.read();
  val2=adc2.read();
  val3=adc3.read();
  if(dut0>0.98f){pwmdir0=0;}if(dut0<0.03f){pwmdir0=1;}
  if(pwmdir0==1){dut0 +=ddu0;pwm0=dut0;}
  if(pwmdir0==0){dut0 -=ddu0;pwm0=dut0;}
  if(dut1>0.97f){pwmdir1=0;}if(dut1<0.04f){pwmdir1=1;}
  if(pwmdir1==1){dut1 +=ddu1;pwm1=dut1;}
  if(pwmdir1==0){dut1 -=ddu1;pwm1=dut1;}
  if(dut2>0.96f){pwmdir2=0;}if(dut2<0.05f){pwmdir2=1;}
  if(pwmdir2==1){dut2 +=ddu2;pwm2=dut2;}
  if(pwmdir2==0){dut2 -=ddu2;pwm2=dut2;}
  pe13=gpio_read(inPutE12);//pe14=inPutE14.gpio_read();pe15=inPutE15.gpio_read();
  if(dispTime>10){dispTime=0;dispMes();testLed();pe9=0;pf15=0;}
  dispTime++;
  wait(0.02);
 }
}

