#include "mbed.h"
#include "TLC59711.h"
#define NUM_TLC59711 1
#define t1 10000
  
TLC59711 tlc(NUM_TLC59711, p7, p5);
Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9, p10);  // tx, rx

//Define functions
//======================
void letter_o();
void _16_columns(uint16_t col);
void _12_filas(uint16_t f0, uint16_t f1, uint16_t f2, uint16_t f3, uint16_t f4, uint16_t f5, uint16_t f6, uint16_t f7, uint16_t f8, uint16_t f9, uint16_t f10, uint16_t f11);
void fila_off(uint8_t num_tlc); void fila_0(uint8_t num_tlc);  void fila_1(uint8_t num_tlc);  void fila_2(uint8_t num_tlc);
void fila_3(uint8_t num_tlc); void fila_4(uint8_t num_tlc); void fila_5(uint8_t num_tlc); void fila_6(uint8_t num_tlc);  
void fila_7(uint8_t num_tlc);  void fila_8(uint8_t num_tlc);  void fila_9(uint8_t num_tlc); void fila_10(uint8_t num_tlc);
void fila_11(uint8_t num_tlc);
//======================



int repit = 8;
uint16_t on = 65535;
uint16_t off = 0;
uint16_t column;
uint8_t column_h, column_l;
uint8_t dato[4];

 
int main() 
{
    device.baud(38400);
    
    while( 1 )
    {
        letter_o();
    }
}


void _12_filas(uint8_t n_tlc, uint16_t f0, uint16_t f1, uint16_t f2, uint16_t f3, uint16_t f4, uint16_t f5, uint16_t f6, uint16_t f7, uint16_t f8, uint16_t f9, uint16_t f10, uint16_t f11)
{
  uint8_t channel[5];
  switch (n_tlc)
  {
      case 0:
        channel[0] = 0;
        channel[1] = 1;
        channel[2] = 2;
        channel[3] = 3;
        break;
      case 1:
        channel[0] = 4;
        channel[1] = 5;
        channel[2] = 6;
        channel[3] = 7;
        break;
      default:
        break;
    }  
  tlc.setLED(channel[0], f0, f1, f2);
  tlc.write();
  tlc.setLED(channel[1], f3, f4, f5);
  tlc.write();
  tlc.setLED(channel[2], f6, f7, f8);
  tlc.write();
  tlc.setLED(channel[3], f9, f10, f11);
  tlc.write();
}

void _32_columns(uint8_t n_uc, uint16_t col)
{
  column_h = (col >> 8);
  column_l = col;
  device.putc('#');
  device.putc(n_uc);
  device.putc(column_h);
  device.putc(column_l);
  device.putc('%');
  
   if(device.readable()) {
            dato[0] = device.getc();
            if(dato[0] == '#'){
                dato[1] = device.getc();
                dato[2] = device.getc();
                dato[3] = device.getc();
            }
    if(dato[1] == 'O' && dato[2] == 'K' && dato[3] == '%')
    {
      /*pc.printf("Column valid  ");
       pc.putc(dato[0]);
       pc.putc(dato[1]);
       pc.putc(dato[2]);
       pc.putc(dato[3]);
       pc.printf("   ");
       pc.putc(column_h, BIN);
       pc.putc(column_l, BIN);
       pc.printf("\n");*/
    }
    else
    {
      /* Serial.print("Column fail");
       pc.putc(dato[0]);
       pc.putc(dato[1]);
       pc.putc(dato[2]);
       pc.putc(dato[3]);
       pc.putc(column_h, BIN);
       pc.putc(column_l, BIN);
       pc.printf("\n");*/
    }
  }
  //wait(0.010);
}

void letter_o()
{
  for(int j = 0; j<=15; j++)
  {
  //**** first row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          //fila_0();
          //_16_columns(n_col_bin);
          
          fila_0(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
    //**** second row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_1(0);
          _32_columns(0,n_col_bin);
          wait_us(t1);
        }
    }
    //**** third row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_2(0);
          _32_columns(0,n_col_bin);
          wait_us(t1);
        }
    }    
  //**** fourth row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_3(0);
          _32_columns(0,n_col_bin);
          wait_us(t1);
        }
    }
  //**** fifth row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_4(0);
          _32_columns(0,n_col_bin);
          wait_us(t1);
        }
    }
  //**** sixth row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_5(0);
          _32_columns(0,n_col_bin);
          wait_us(t1);
        }
    }
  //**** seventh row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_6(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  //**** eight row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_7(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  //**** ninth row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_8(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  //**** tenth row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_9(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  //**** eleventh row  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_10(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  //**** twelfth column  ******
  for(double k = 0; k < 16; k++)
  {
      for(int i =0; i<repit; i++)
      {
          double n_col = pow(2, k);
          uint16_t n_col_bin = n_col;
          fila_11(0);
          _32_columns(0, n_col_bin);
          wait_us(t1);
        }
    }
  }
}
void fila_off(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,off,off,off,off,off);
}
void fila_0(uint8_t num_tlc)
{
    _12_filas(num_tlc,on,off,off,off,off,off,off,off,off,off,off,off);
}
void fila_1(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,on,off,off,off,off,off,off,off,off,off,off);
}
void fila_2(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,on,off,off,off,off,off,off,off,off,off);
}
void fila_3(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,on,off,off,off,off,off,off,off,off);
}
void fila_4(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,on,off,off,off,off,off,off,off);
}
void fila_5(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,on,off,off,off,off,off,off);
}
void fila_6(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,on,off,off,off,off,off);
}
void fila_7(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,on,off,off,off,off);
}
void fila_8(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,off,on,off,off,off);
}
void fila_9(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,off,off,on,off,off);
}
void fila_10(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,off,off,off,on,off);
}
void fila_11(uint8_t num_tlc)
{
    _12_filas(num_tlc,off,off,off,off,off,off,off,off,off,off,off,on);
}