#include "mbed.h"
#include <string.h>

DigitalOut led1(LED1);
DigitalIn button(PC_13);

Serial pc(USBTX, USBRX);

AnalogOut v_out(PA_4);

void blink(int times) {
    for (int i = 0; i < times; i++) {
        led1 = 1;
        wait(0.5);
        led1 = 0;
        wait(0.5);
    }
}

void led(int state) {
    if(state == 1) 
        led1 = 1;
    else
        led1 = 0;
}

void buttonread() {
    if(!button.read()) 
        pc.printf("PRESSED\n\r");
    else 
        pc.printf("RELEASED\n\r");
}

void vout(float v) {
    if (v > 3 || v < .5) {
        pc.printf("0.5 - 3\n\r");
    } else {
        v_out.write_u16((v/3.3)*65535);
        wait(20);
        v_out.write_u16(0);
    }
}

 
int main() {
    pc.printf("Nucleo is up and running\n\r");
    char input[15], c;
    int i, reps;
    while (true) {
        input[0] = '\0';
        i = 0;
        reps = 0;
    while(true) {
       c = pc.getc();
       pc.putc(c);
       if (c == 0x0D) break;
       input[i]=c;
       i++;
    }
    input[i] = '\0';
    pc.printf("\n");
    if (strcmp("OFF", input) == 0) break;
    if (strcmp("BUTTON", input) == 0) {
        pc.printf("OK\n\r");
        buttonread();
    }
    else {
        char *first = strtok(input, " ");
        char *second = strtok(NULL, " ");
    
        if (strcmp("BLINK", first) ==0) {
            pc.printf("OK\n\r");
            reps = atoi(second);
            blink(reps);
        }
        else if (strcmp("LED", first) == 0) {
            if (strcmp("ON", second) == 0) led(1);
            if (strcmp("OFF", second) ==0) led(0);
            pc.printf("OK\n\r");
        }
        else if (strcmp("DC", first) == 0) {
            float volt = atof(second);
            vout(volt);
            pc.printf("OK\n\r");
        }
        else pc.printf("ERR\n\r");
    }
    }
    return(0);
}

