// Basic example show how to read a tag uid.
// you can use i2c, spi, hsu interface.
//
// Assembled by dotnfc as Arducleo Sample
// 2016/09/10



#include "mbed.h"
#include "PN532.h"
#include "PN532_HSU.h"
#include "PN532_SPI.h"
#include "PN532_I2C.h"

Serial pc(SERIAL_TX, SERIAL_RX);

// ----------------------------------------- HSU
HardwareSerial pn532_hsu (PC_10, PC_11);
PN532_HSU pn532_if (pn532_hsu);

PN532 nfc(pn532_if);

/*==============================================================================
 * \brief init the peripheral
 */
void setup(void)
{
    uint32_t versiondata = 0;
    pc.baud(115200);
    pc.printf ("Hello!\n");

    while (1) {
        nfc.begin();
        //nfc.SAMConfig();
        versiondata = nfc.getFirmwareVersion();
        if (! versiondata) {
            pc.printf("Didn't find PN53x board\n\n");
            wait_ms(500);
        } else {
            break;
        }
    }

    // Got ok data, print it out!
    pc.printf ("Found chip PN5%02X , Firmware ver. %d.%d\n",
               (versiondata>>24) & 0xFF,
               (versiondata>>16) & 0xFF,
               (versiondata>>8) & 0xFF);

    // Set the max number of retry attempts to read from a card
    // This prevents us from waiting forever for a card, which is
    // the default behaviour of the PN532.
    nfc.setPassiveActivationRetries(0xFF);

    // configure board to read RFID tags
    nfc.SAMConfig();

    pc.printf ("\nWaiting for an ISO14443A card\n");
}


/*==============================================================================
 * \brief main entry
 */
int main()
{
    setup();

    //PN532 GPIO 例子
    //对于P3
    nfc.writeGPIOP3(PN532_GPIO_P30); //把P30设置为1，其余P3设置为0
    nfc.writeGPIOP3(PN532_GPIO_P30|PN532_GPIO_P32); //把P30,P32设置为1，其余P3设置为0
    nfc.writeGPIOP3(0); //把P3全部设置为0

    //对于P7
    nfc.writeGPIOP7(PN532_GPIO_P70); //把P70设置为1，其余P7设置为0
    nfc.writeGPIOP7(PN532_GPIO_P70|PN532_GPIO_P72); //把P70,P72设置为1，其余P7设置为0
    nfc.writeGPIOP7(0); //把P7全部设置为0

    while (1);
}

