#include "mbed.h"
#include "SDFileSystem.h"

// mosi, miso, sclk, name
SDFileSystem sd(PB_15, PB_14, PB_13, PA_9, "sd"); 

int main()
{
    // 读文件例子
    FILE *fp = fopen("/sd/test.txt", "r"); //打开文件，路径以“/sd/”开头

    if (fp == NULL) //打开失败，原因可能是文件不存在，或卡没有连接好
    {
        printf("open error!!\r\n");
        return 1;
    }
    printf("file opened for read\r\n");
    char buf[64];
    while (fgets(buf, sizeof(buf), fp) != NULL) //读入一行的C函数
    {    
        printf("read '%s'\r\n", buf);
    }
    fclose(fp);  //关闭文件，释放资源
    
    //printf("card type is 0x%x\r\n" , sd.card_type());
    
    // 写文件例子
    FILE *fp2 = fopen("/sd/write.txt", "w");
    if (fp2 == NULL)
    {
        printf("open error2!!\r\n");
        return 1;
    }
    printf("file opened for write\r\n");
    fprintf(fp2, "hello\r\n");
    fprintf(fp2, "%d", 23333);
    fclose(fp2);  //写完文件要记得关闭，不然可能没保存上

    return 0;
}
