/***************************************************************
功能 : mbed的串联74HC595数码管驱动
作者 : 陈欢 清华大学电机工程与应用电子技术系
邮箱 : h-che14@mails.tsinghua.edu.cn OR heroistired@gmail.com
声明 : 
本程序仅供学习与交流使用,如需他用,须联系作者
本程序可以随意更改,但须保留本信息页
All rights reserved
2017.6.16
***************************************************************/

#include "Nixie.h"

Nixie::Nixie(PinName _DIO, PinName _SCK, PinName _RCK): DIO(_DIO), SCK(_SCK), RCK(_RCK)
{
    DIO = 0;
    SCK = 0;
    RCK = 0;
}

void Nixie::NixieShowNumber(int Number, int dot)
{
    int8_t pos = 7;
    do{
        NixieShow(Number%10,pos,dot==pos);
        Number /= 10;
        pos --;
    }while(Number != 0 && pos >= 0);
}
    
void Nixie::NixieShow(int Num, int Pos, bool WithDot)
{
    char c, num;
    
    if(WithDot)
    {
        num=NumCode[Num]-0x80;
        for(c=0;c<8;c++)
        {
            SCK=0;
            DIO=num&0x80;
            num<<=1;
            SCK=1;
        }
    }
    else
    {
        num=NumCode[Num];
        for(c=0;c<8;c++)
        {
            SCK=0;
            DIO=num&0x80;
            num<<=1;
            SCK=1;
        }
    }
      
    num=SegBit[Pos];
    for(c=0;c<8;c++)
    {
        SCK=0;
        DIO=num&0x80;
        num<<=1;
        SCK=1;
    }
    RCK=0;
    RCK=1;
}