/*-----------------------------------------------------
 File Name : main.cpp
 Purpose : For tcs3200 sensor
 Creation Date : 24-06-2017
 Last Modified :
 Created By : Jeasine Ma [jeasinema[at]gmail[dot]com]
-----------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdarg>

#include "mbed.h"
#include "TextLCD.h"
#include "color.h"

int main() {
    TextLCD lcd(PC_13, PC_14, PC_15, PA_0, PA_1, PB_4, TextLCD::LCD20x4); // rs, e, d4-d7, model

    // S0,S1,S2,S3,OUT
    ColorSensor color(PB_11, PA_12, PB_1, PB_10, PB_9);                            //用5个GPIO管脚

    while(1) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        lcd.cls();
        lcd.printf("Color:\nR:%d G:%d B:%d", red, green, blue);
        wait(1);
    }
}