/******************************************************************************************
* 版权     ：
* 模块名称 ：st7920驱动的12864液晶的串行工作方式驱动程序
* 作者     ：
* 创建日期 ：2009-10-15
* 功能概要 ：
*----------------------------------------修改历史------------------------------------------
* 当前版本 ：       修改人：                  修改日期：
* 修改说明 ：
******************************************************************************************/

#include "chn12864.h"
#include "mbed.h"

#define x1    0x80
#define x2    0x88
#define y     0x80
#define comm  0
#define dat   1

static uint8_t const  num_lcd[] = {"0123456789 :.-"};

/******************************************************************************************
* 函数名称    ：Lcd_init
* 功能描述    ：初始化LCD
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2008-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
ChnLCD12864::ChnLCD12864(PinName sid, PinName sck, PinName cs) : _sid(sid),_sck(sck),_cs(cs)
{
    wait(1e-3 * 50); //启动等待，等LCM讲入工作状态
    _cs=1;
    Write_Char(0, 0x30); //8 位介面，基本指令集
    wait(1e-3 * 1);
    Write_Char(0, 0x30); //8 位介面，基本指令集
    Write_Char(0, 0x30); //8 位介面，基本指令集
    Write_Char(0, 0x0c); //显示打开，光标关，反白关
    Write_Char(0, 0x01); //清屏，将DDRAM的地址计数器归零
    locate(0,0);
}

/******************************************************************************************
* 函数名称    ：Write_char
* 功能描述    ：写指令或数据
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2006-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::Write_Char(uint8_t start, uint8_t ddata)
{
    uint8_t start_data, Hdata, Ldata;
    if (start == 0)
        start_data = 0xf8; //写指令
    else
        start_data = 0xfa; //写数据

    Hdata = ddata & 0xf0; //取高四位
    Ldata = (ddata << 4) & 0xf0; //取低四位
    Send_Byte(start_data);   //发送起始信号
    wait(1e-6 * 10);
    Send_Byte(Hdata);       //发送高四位
    wait(1e-6 * 10);
    Send_Byte(Ldata);    //发送低四位
    wait(1e-6 * 10);
}

/******************************************************************************************
* 函数名称    ：Send_byte
* 功能描述    ：发送一个字节
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2009-10-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::Send_Byte(uint8_t bbyte)
{
    volatile uint8_t i;
    for (i = 0; i < 8; i++) {
        if ((bbyte) & 0x80)
            _sid=1; //取出最高位
        else
            _sid=0;
        _sck=1;
        wait(1e-6 * 100);  //延时 lcd读取数据
        _sck=0;
        bbyte <<= 1; //左移
    }
}


/******************************************************************************************
* 函数名称    ：LCD12864_Clr_Scr
* 功能描述    ：清屏函数
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2009-10-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::cls(void)//清屏函数
{
    Write_Char(0, 0x01);
}

/******************************************************************************************
* 函数名称    ： LCD12864_set_xy
* 功能描述    ：设置LCD显示的起始位置，X为行，Y为列
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2006-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::locate( uint8_t col, uint8_t row )
{
    uint8_t address;
    uint8_t X = row, Y = col;
    _row = X;
    _column = Y*2;
    switch (X) {
    case 0:
        address = 0x80 + Y;
        break;
    case 1:
        address = 0x90 + Y;
        break;
    case 2:
        address = 0x88 + Y;
        break;
    case 3:
        address = 0x98 + Y;
        break;
    default:
        address = 0x80 + Y;
        break;
    }
    Write_Char(0, address);
}

/******************************************************************************************
* 函数名称    ：LCD12864_Write_string
* 功能描述    ：中英文字符串显示函数
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2006-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::Write_String(uint8_t X, uint8_t Y, char  *s)
{
    locate( Y, X );

    while (*s) {
        Write_Char( 1, *s );
        s ++;
        wait(1e-3 * 1);
    }
}

void ChnLCD12864::Write_String_Length(uint8_t X, uint8_t Y, char  *s, int length)
{
    locate( Y, X );

    while(length--) {
        Write_Char( 1, *s );
        s ++;
        wait(1e-3 * 1);
    }
}

/******************************************************************************************
* 函数名称    ：LCD12864_Write_number
* 功能描述    ：数字显示函数
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2006-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::Write_Number(uint8_t s)// 数字显示函数
{
    Write_Char(1, num_lcd[s]);
    wait(1e-3 * 1);
}

/******************************************************************************************
* 函数名称    ：img_disp
* 功能描述    ：显示图形
* 参数        ：  参数名称： 输入/输出？ 类型  描述
*
* 返回值      ：
* 作者        ：
* 创建日期    ：2006-12-19
* 全局变量    ：
* 全局静态变量：
* 局部静态变量：
*----------------------------------------修改历史------------------------------------------
* 当前版本    ：     修改人：                  修改日期：
* 修改说明    ：
******************************************************************************************/
void ChnLCD12864::Display_Img(uint8_t const *img)
{
    uint8_t i, j;
    for (j = 0; j < 32; j++) {
        for (i = 0; i < 8; i++) {
            Write_Char(comm, 0x34);
            wait(1e-3 * 10);
            Write_Char(comm, y + j);
            wait(1e-3 * 10);
            Write_Char(comm, x1 + i);
            wait(1e-3 * 10);
            Write_Char(comm, 0x30);
            wait(1e-3 * 10);
            Write_Char(dat, img[j * 16 + i * 2]);
            wait(1e-3 * 10);
            Write_Char(dat, img[j * 16 + i * 2 + 1]);
            wait(1e-3 * 10);
        }
    }
    for (j = 32; j < 64; j++) {
        for (i = 0; i < 8; i++) {
            Write_Char(comm, 0x34);
            wait(1e-3 * 10);
            Write_Char(comm, y + j - 32);
            wait(1e-3 * 10);
            Write_Char(comm, x2 + i);
            wait(1e-3 * 10);
            Write_Char(comm, 0x30);
            wait(1e-3 * 10);
            Write_Char(dat, img[j * 16 + i * 2]);
            wait(1e-3 * 10);
            Write_Char(dat, img[j * 16 + i * 2 + 1]);
            wait(1e-3 * 10);
        }
    }
    wait(1e-3 * 10);
    Write_Char(comm, 0x36);
}


int ChnLCD12864::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= 4) {
            _row = 0;
        }
    } else {
        Write_Char( 1, value );
        wait(1e-3 * 1);
        _column++;
        if (_column >= 16) {
            _column = 0;
            _row++;
            if (_row >= 4) {
                _row = 0;
            }
            locate(0, _row);
        }
    }
    return value;
}