#ifndef _12864_H__
#define _12864_H__

#include "mbed.h"

class ChnLCD12864 : public Stream {
    DigitalOut _sid, _sck, _cs;
    uint8_t _column, _row;

    void Send_Byte(uint8_t bbyte);
    void Write_Char(uint8_t start, uint8_t ddata);
public:
    ChnLCD12864(PinName sid, PinName sck, PinName cs);
    void locate( uint8_t col, uint8_t row );
    void cls(void);
    void Write_Number(uint8_t s);
    void Write_String(uint8_t X, uint8_t Y, char  *s);
    void Write_String_Length(uint8_t X, uint8_t Y, char  *s, int length);
    void Display_Img(uint8_t const *img);
protected:

    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc(){return -1;}
};
#endif