#ifndef MYTANK_H
#define MYTANK_H

#include "list"
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "vector"


/** MyTank Class
 * @brief Create the player's tank and set the tank behavior and properties
 * @author HaoZhang
 * @date May, 2020
 */

class Bullet;

class ETank;


class MyTank
{
public:

     /**Initializes the position and properties of the tank
      *@param pad - Make the led light
      *@param lcd - Initialize the lcd in private
      */
     void init(Gamepad &pad,N5110 &lcd) ;
     /**change the position of tank
      *@param x - the value of tank' x position
      *@param y - the value of tank' y position
      */
     void setpos(int x, int y);
     /**get the direction of tank
      *@param pad - get the direction
      */
     void read_input(Gamepad &pad);
     /**draw the tank
      *@param lcd - Target Screen
      */
     void draw(N5110 &lcd);
     /**update the tank
      *@param etank - the enemy's tanks
      */
     void update(list<ETank*>&etank);
     /**the attack of player
      *@param lstBullets - the bullets of player's tank
      *@param v - get the position of the player's tank 
      *@param pad - get the direction and check if the button pressed
      *@param etank - the enemy's tanks
      *@param num_tank - the number of enemy's tank
      */
     void attack(list<Bullet*>&lstBullets,Vector2D v,Gamepad &pad,N5110 &lcd,list<ETank*>&etank,int &num_tank);
     /**HP-1*/
     void subHP(); 
     /** HP +1*/
     void addHP(); 
      /** for the shop :buy the HP
       *@param pad - check if the button pressed
       */
     void setHP(Gamepad &pad);  
     
     /** Get the HP
      *@return the HP
      */
     int MT_HP();
     
     int totalHP; 
     
     int attack_gap; // Tank attack interval
     Vector2D get_pos();
     Direction get_direction();
    
     
     
private:
    int _x;
    int _y;
    int HP;
    
    int count;

    N5110 lcd;
    Direction _d;
    Direction _pre_d;
    /** Check the collision between player's tank and enemy's tanks
     * @param etank - the enemy's tanks
     */
    void check_tank_collsion(list<ETank*>&etank);
    /** Check the pixel around player's tank */
    void check_pixel();
};

#endif