#ifndef MAP_H
#define MAP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ETank.h"
#include "MyTank.h"
#include "vector"
/** Map Class
 * @brief Create and draw the map 
 * @author HaoZhang
 * @date May, 2020
 */

class Map
{
public:
     /**Initializes the position of the square used to draw the graph
      *@param lcd - Target Screen
      */
    void init(N5110 &lcd);
     /**update the position of the square used to draw the graph
      *@param pad - To move square around
      */
    void update(Gamepad &pad);
    /**Draw a square for drawing
     *@param lcd - Target Screen
     */
    void paddraw(N5110 &lcd); 
    /**Use the square to draw the map
     *@param pad - check if the button pressed
     *@param lcd - Target Screen
     */
    void drawmap(Gamepad &pad,N5110 &lcd);
    /**get the position*/
    Vector2D getpos(); 
     
private:   
    
    Direction _d;
    
    int _x;
    int _y;
    /**use for storing the map*/
    N5110 lcd;
};

#endif