#ifndef ETANK_H
#define ETANK_H

#include "time.h"
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "list"
#include "vector"

/** ETank Class
 * @brief Create the enemy's tank and set the tank behavior and properties
 * @author HaoZhang
 * @date May, 2020
 */


class Bullet;

class MyTank;

class ETank
{

public:
     /** Constructor 
      *@param lcd - Target Screen
      *@param pad - set the tone when the tank create
     */
     ETank(N5110 &lcd,Gamepad &pad);
     /** Destructor */
     ~ETank();
     /**change the position of tank
      *@param x - the value of tank' x position
      *@param y - the value of tank' y position
     */
     void setpos(int x, int y);
     /**draw the tank
       *@param lcd - Target Screen
     */
     void drawE(N5110 &lcd);
     /**set the direction of tank
       @param mt - player's tank
     */
     void direction(MyTank &mt);
     /**update the tank
       *@param lcd - Target Screen
       *@param mt - player's tank
       *@param etank - the bullets of enemy's tank
     */
     void update(N5110 &lcd,MyTank &mt,list<ETank*>&etank);
     /**the attack of enemy's tank
      *@param v - get the position of the player's tank 
      *@param pad - get the direction 
      *@param mtbullet - the bullets of player's tank
      *@param et_attack - The threshold that an attack needs to reach
      *@param timegap - Attack interval
      */
     void attack(Vector2D v,Gamepad &pad,N5110 &lcd,MyTank &mt,list<Bullet*> &mtbullet,int et_attack,int timegap);
     /** Store the bullets */
     list<Bullet*> lstBullets;

     Vector2D get_pos(); 
         
private:
    int _x;
    int _y;
    int count;
    int MT_HP;
    Direction _d;
    /** Check the collision between player's tank and enemy's tanks
     *@param lcd - Target Screen
     *@param mt - the player's tanks
     */
    void check_tank_collsion(N5110&lcd,MyTank &mt);
     /** Check the collision among enemy's tanks
      *@param etank - the enemy's tanks
      */
    void check_self_collsion(list<ETank*>&etank);
    /** Check the pixel around player's tank */
    void check_pixel(N5110 &lcd);
    /** The template of checking the collision
     *@param t1- tank1
     *@param t2- tank2
     *@return Whether or not there is a collision
     */
    bool collsion_check(Vector2D t1,Vector2D t2);
};


#endif