#ifndef Bullet_H
#define Bullet_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ETank.h"
#include "MyTank.h"
#include "iostream"
#include "vector"
#include "list"

/** Bullet Class
 * @brief Create the bullets of tanks and set the bullets behavior and properties
 * @author HaoZhang
 * @date May, 2020
 */
class MyTank;
class ETank;

class Bullet
{
 public:
    /** Constructor */
    Bullet();
    /** Constructor 
     *@param pad - get the direction of tank
     *@param p - get the position of tank
     */
    Bullet(Gamepad &pad,Vector2D p);
    /** update the bullet of player's tank
     *@param lcd - Target Screen
     *@param prem_d - Keep the bullets in the same direction 
     */
    void update(N5110 &lcd,Direction prem_d);
    /**update the bullet of enemy's tank
     *@param lcd - Target Screen
     *@param e_d - Keep the bullets in the same direction 
     */
    void et_update(N5110 &lcd,Direction e_d);
    /** It is used with bullet_collison to eliminate bullets
     *@param x -  the value of bullet' x position
     *@param y - the value of bullet' y position
     */
    void set_pos(int x,int y);
    /**check if the bullet go out of the screen */  
    bool destroy();
    /**Check for collisions between bullets
     *@param t_pos - the position of bullets
     *@return the result of check
     */  
    bool destroyT(Vector2D t_pos);
    /**Eliminate collision bullets
     *@param lstBullets - the bullets of enemy
     *@param mtbullet - the bullets of player
    */
    void bullet_collison(list<Bullet*> &lstBullets,list<Bullet*>&mtbullet);
    /**get the position of bullets*/
    Vector2D get_pos();

    
 private:

     int _x;
     int _y; 
     Direction m_d;
     /** Used to store the direction of player's tank bullets*/
     vector<Direction> v1;
     /** Used to store the direction of enemy's tank bullets*/
     vector<Direction> v2;
     


};





#endif