/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"

/* Definitions ---------------------------------------------------------------*/

/* Number of steps. */
#define STEPS_1 (200 * 2)   /* 1 revolution given a 400 steps motor configured at 1/2 microstep mode. */

/* Speed in pps (Pulses Per Second).
   In Full Step mode: 1 pps = 1 step/s).
   In 1/N Step Mode:  N pps = 1 step/s). */
#define SPEED_1 500 //pps

/* Variables -----------------------------------------------------------------*/
DigitalIn botao(USER_BUTTON); //Declarando o botão de usuário
int speed;

/* Initialization parameters. */
L6474_init_t init = {
    1000,                              /* Acceleration rate in pps^2. Range: (0..+inf). */
    1000,                              /* Deceleration rate in pps^2. Range: (0..+inf). */
    1200,                             /* Maximum speed in pps. Range: (30..10000]. */
    30,                              /* Minimum speed in pps. Range: [30..10000). */
    250,                              /* Torque regulation current in mA. Range: 31.25mA to 4000mA. */
    L6474_OCD_TH_750mA,               /* Overcurrent threshold (OCD_TH register). */
    L6474_CONFIG_OC_SD_ENABLE,        /* Overcurrent shutwdown (OC_SD field of CONFIG register). */
    L6474_CONFIG_EN_TQREG_TVAL_USED,  /* Torque regulation method (EN_TQREG field of CONFIG register). */
    L6474_STEP_SEL_1_2,               /* Step selection (STEP_SEL field of STEP_MODE register). */
    L6474_SYNC_SEL_1_2,               /* Sync selection (SYNC_SEL field of STEP_MODE register). */
    L6474_FAST_STEP_12us,             /* Fall time value (T_FAST field of T_FAST register). Range: 2us to 32us. */
    L6474_TOFF_FAST_8us,              /* Maximum fast decay time (T_OFF field of T_FAST register). Range: 2us to 32us. */
    3,                                /* Minimum ON time in us (TON_MIN register). Range: 0.5us to 64us. */
    21,                               /* Minimum OFF time in us (TOFF_MIN register). Range: 0.5us to 64us. */
    L6474_CONFIG_TOFF_044us,          /* Target Swicthing Period (field TOFF of CONFIG register). */
    L6474_CONFIG_SR_320V_us,          /* Slew rate (POW_SR field of CONFIG register). */
    L6474_CONFIG_INT_16MHZ,           /* Clock setting (OSC_CLK_SEL field of CONFIG register). */
    L6474_ALARM_EN_OVERCURRENT |
    L6474_ALARM_EN_THERMAL_SHUTDOWN |
    L6474_ALARM_EN_THERMAL_WARNING |
    L6474_ALARM_EN_UNDERVOLTAGE |
    L6474_ALARM_EN_SW_TURN_ON |
    L6474_ALARM_EN_WRONG_NPERF_CMD    /* Alarm (ALARM_EN register). */
};

/* Motor Control Component. */
L6474 *motor;

/* Functions -----------------------------------------------------------------*/

void flag_irq_handler(void)
{
    /* Set ISR flag. */
    motor->isr_flag = TRUE;

    /* Get the value of the status register. */
    unsigned int status = motor->get_status();

    /* Check NOTPERF_CMD flag: if set, the command received by SPI can't be performed. */
    /* This often occures when a command is sent to the L6474 while it is not in HiZ state. */
    if ((status & L6474_STATUS_NOTPERF_CMD) == L6474_STATUS_NOTPERF_CMD) {
        printf("    WARNING: \"FLAG\" interrupt triggered. Non-performable command detected when updating L6474's registers while not in HiZ state.\r\n");
    }

    /* Reset ISR flag. */
    motor->isr_flag = FALSE;
}

/* Main ----------------------------------------------------------------------*/
int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Component. */
    motor = new L6474(D2, D8, D7, D9, D10, dev_spi);
    if (motor->init(&init) != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }

    /* Attaching and enabling interrupt handlers. */
    motor->attach_flag_irq(&flag_irq_handler);
    motor->enable_flag_irq();



    while (1) {
        
        /* Getting motor speed */
        speed = motor->get_speed();

        /* Printing speed to the console. */
        printf("%d\r\n", speed);

        if (botao == 0) {
            /* Increasing the speed. */
            motor->set_max_speed(SPEED_1);

            /* Moving 400 half steps in the forward direction. */
            motor->move(StepperMotor::FWD, STEPS_1);

            /* Waiting while the motor is active. */
            motor->wait_while_active();

            wait(1); //Espera 1s antes de mudar de direç˜åo

            /* Increasing the speed. */
            motor->set_max_speed(SPEED_1);

            /* Moving 400 half steps in the backward direction. */
            motor->move(StepperMotor::BWD, STEPS_1);
        }
    }
}
