#include "mbed.h"

// pinos placa IHM07M1 - Usa para PWM
PwmOut IN_1 (PA_8);
PwmOut IN_2 (PA_9);
PwmOut IN_3 (PA_10);

// pinos placa IHM07M1 ENABLE
DigitalOut EN_1 (PC_10);
DigitalOut EN_2 (PC_11);
DigitalOut EN_3 (PC_12);

// Botão de usuário
DigitalIn botao (USER_BUTTON);

// Potenciômetro
AnalogIn pot (PB_1);

float pot_read;// Recebe o valor do potenciometro
float tempo_pot;// Tempo para alternar entre as bobinas em funcao do potenciometro - Controla a velocidade do motor

float tempo = 0.006; // Tempo base para alternar entre as bobinas - Controla a velocidade do motor
float potencia = 1; // Duty Cycle do PWM - Controla o torque do motor
bool funciona = 0;

int main()
{
    // configurações iniciais
    IN_1.period_ms(1); // PWM
    IN_2.period_ms(1); // PWM
    IN_3.period_ms(1); // PWM
    
    while(1) {

        pot_read = pot.read();
//        printf("pot= %1.2f\n\r",pot_read);
        tempo_pot = tempo - tempo*pot_read/1.5; //Controla o tempo para alternar entre bobinas
        potencia = pot_read/5 + 0.75; //Controla o DC do PWM para aumentar o torque confome o potenciômetro
//        printf("tempo= %1.5f\n\r",tempo_pot);

        if (botao == 0) { //Se botão de usuário for pressionado liga o motor
            funciona = 1;
            wait(0.5);
        }
        if (funciona == 0) { //Motor desligado
            
            EN_1 = 2; // Braço 1 (A)
            EN_2 = 2; // Braço 2 (B)
            EN_3 = 2; // Braço 3 (C)
            IN_1.write(0); // PWM com valor 0%
            IN_2.write(0); // PWM com valor 0%
            IN_3.write(0); // PWM com valor 0%
        }
        
        if (funciona == 1) { //Motor Ligado

            // 1º
            EN_1 = 1; // Braço 1 (A)
            EN_2 = 2; // Braço 2 (B)
            EN_3 = 2; // Braço 3 (C)
            IN_1.write(potencia); // PWM com valor do DC
            IN_2.write(0); // PWM com valor 0%
            IN_3.write(0); // PWM com valor 0%
            wait(tempo_pot); //Espera tempo para mudar de bobina
            // 2º
            EN_1 = 2; // Braço 1 (A)
            EN_2 = 2; // Braço 2 (B)
            EN_3 = 0; // Braço 3 (C)
            IN_1.write(0); // PWM com valor 0%
            IN_2.write(0); // PWM com valor 0%
            IN_3.write(potencia); // PWM com valor do DC
            wait(tempo_pot); //Espera tempo para mudar de bobina

            // 3º
            EN_1 = 2; // Braço 1 (A)
            EN_2 = 1; // Braço 2 (B)
            EN_3 = 2; // Braço 3 (C)
            IN_1.write(0); // PWM com valor 0%
            IN_2.write(potencia); // PWM com valor do DC
            IN_3.write(0); // PWM com valor 0%
            wait(tempo_pot); //Espera tempo para mudar de bobina
            // 4º
            EN_1 = 0; // Braço 1 (A)
            EN_2 = 2; // Braço 2 (B)
            EN_3 = 2; // Braço 3 (C)
            IN_1.write(potencia); // PWM com valor do DC
            IN_2.write(0); // PWM com valor 0%
            IN_3.write(0); // PWM com valor 0%
            wait(tempo_pot); //Espera tempo para mudar de bobina
            // 5º
            EN_1 = 2; // Braço 1 (A)
            EN_2 = 2; // Braço 2 (B)
            EN_3 = 1; // Braço 3 (C)
            IN_1.write(0); // PWM com valor 0%
            IN_2.write(0); // PWM com valor 0%
            IN_3.write(potencia); // PWM com valor do DC
            wait(tempo_pot); //Espera tempo para mudar de bobina
            //6º
            EN_1 = 2; // Braço 1 (A)
            EN_2 = 0; // Braço 2 (B)
            EN_3 = 2; // Braço 3 (C)
            IN_1.write(0); // PWM com valor 0%
            IN_2.write(potencia); // PWM com valor do DC
            IN_3.write(0); // PWM com valor 0%
            wait(tempo_pot); //Espera tempo para mudar de bobina

            if (botao == 0) { // Se bot˜åo de usuário for pressionado desliga o motor
                funciona = 0;
                wait(0.5);
            }
        }
    }
}