#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "OAuth4Tw.h"
#include "BME280.h"
#include "TSL2561_I2C.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
#ifndef USE_FIXEDIP
EthernetInterface eth;
#else
EthernetNetIf eth(
  IpAddr(192,168,0,210), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,0,1), //Gateway
  IpAddr(192,168,0,1)  //DNS
);
#endif

NTPClient ntp;
BME280 sensor(p9, p10);
TSL2561_I2C lum_sensor( p9, p10 ); 

OAuth4Tw oa4t("Your Consumer key", // Consumer key
                  "Your Consumer secret", // Consumer secret
                  "Your Access token", // Access token
                  "Your Access token secret"); // Access token secret

#if defined(TARGET_LPC1768)
#define RESPONSE_BUFFER_SIZE 512
#elif defined(TARGET_K64F) || defined(TARGET_LPC4088)
#define RESPONSE_BUFFER_SIZE 4096
#else
#error not tested platform.
#endif

char response_buffer[RESPONSE_BUFFER_SIZE];
HTTPText response(response_buffer, sizeof(response_buffer));

// prototype
void updateTime();
void EnvTweet();
void example_getUserData();

// Constant Value
const int TweetIntervalSec=600; // 600sec 10min

int main()
{
    pc.baud(115200);

    eth.init(); //Use DHCP
    printf("Initialized, MAC: %s\n", eth.getMACAddress());

    int ret;
    while ((ret = eth.connect()) != 0) {
        printf("Error eth.connect() - ret = %d\n", ret);
    }

    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

    // requires accurate time, for OAuth Authorization.
    updateTime();

    while (1) {

        EnvTweet();

        example_getUserData();

        // Wait 600 seconds for next time.
        for (int t=0; t<TweetIntervalSec; t++) {
            myled = 1;
            wait(0.2);
            myled = 0;
            wait(0.8);
        }

        printf("\n");
    }
}


void updateTime()
{
    printf("Trying to update time...\n");

    time_t ctTime;
    NTPResult result;

    while (1) {
        result = ntp.setTime("pool.ntp.org");
        //result = ntp.setTime("pool.ntp.org", NTP_DEFAULT_PORT, 2000);

        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC): %s\n", ctime(&ctTime));
            break;
        }

        switch (result) {
            case NTP_CONN:      ///<Connection error
                printf("Connection error\n");
                break;
            case NTP_TIMEOUT:   ///<Connection timeout
                printf("Connection timeout\n");
                break;
            case NTP_PRTCL:     ///<Protocol error
                printf("Protocol error\n");
                break;
            case NTP_DNS:       ///<Could not resolve name
                printf("Could not resolve name\n");
                break;
            default:
                printf("Error result=%d\n", result);
                break;
        }

        wait(5);
    }
}

void EnvTweet()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json"
                       "?status=%s";
    char url2[128];
    char status[90];
    
    time_t ctTime;
    time(&ctTime);
    
    sprintf(status,"温度：%2.2f℃ 気圧：%04.2fhPa 湿度：%2.2f%% 照度：%4.2flx\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity(),lum_sensor.getLux());

    snprintf(url2, sizeof(url2), url, status);

    HTTPResult result = oa4t.post(url2, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_getUserData()
{
    const char url[] = "https://api.twitter.com/1.1/users/show.json"
                       "?screen_name=twitter";

    HTTPResult result = oa4t.get(url, &response);

    if (result == HTTP_OK) {
        printf("GET success.\n%s\n", response_buffer);
    } else {
        printf("GET error. (result = %d)\n", result);
    }
}