#include "mbed.h"
#include "USBKeyboard.h"
#include "DEH970Ctrl.h"

#define DEBUG

//main loop
const unsigned ADAvg=8;

//main roop wait time(ms)
const int wait_time_ms=100;
const int wait_time_keydet_ms=500; 

//AD value range
//2.5ohm button (Mode or SEEK+)
const unsigned Res2R5MinAD=0x0000;
const unsigned Res2R5MaxAD=0x00C4;
//0.3kohm button (SEEK-)
const unsigned Res300MinAD=0x2F42;
const unsigned Res300MaxAD=0x46E4;
//1kohm button (VOL+)
const unsigned Res1kMinAD=0x7332;
const unsigned Res1kMaxAD=0x8ccc;
//3.1kohm button (VOL-)
const unsigned Res3kMinAD=0xAE33;
const unsigned Res3kMaxAD=0xD4E9;


Ticker tick;
AnalogIn Key1(A0);
AnalogIn Key2(A1);
DigitalOut HBLed(LED2);
DigitalOut IRLed(LED1);
DigitalOut USBLed(LED3);
PwmOut IRPort(PTB2);
DEH970Controller *DEH970Ctrl;
USBKeyboard *Keyboard;

int main()
{
    unsigned Key1AD,Key2AD;
    unsigned i;
    
    printf("start!\n");

    DEH970Ctrl=new DEH970Controller(&IRPort);

    printf("start!\n");

    Keyboard=new USBKeyboard();

    printf("USB start!\n");

    HBLed=true;
    IRLed=true;

    printf("Start!");
    
    while(1)
    {   Key1AD=0;
        Key2AD=0;
        IRLed=true;
        USBLed=true;
        
        //キーAD値の8回平均を取得
        for(i=0;i<ADAvg;i++)
        {   Key1AD=Key1AD+(unsigned)Key1.read_u16();
            Key2AD=Key2AD+(unsigned)Key2.read_u16();
        }
        
        Key1AD/=ADAvg;
        Key2AD/=ADAvg;
        
#ifdef DEBUG
    printf("AD Value:%x %x\n",Key1AD,Key2AD);
#endif

        //MODE SW
        if(Res2R5MinAD<=Key2AD && Key2AD<=Res2R5MaxAD)
        {
#ifdef DEBUG
            printf("MODE SW\n");
#endif
            USBLed=false;
            Keyboard->mediaControl(KEY_PLAY_PAUSE);
            wait_ms(wait_time_keydet_ms);
        }   
        //SEEK+ SW
        else if(Res2R5MinAD<=Key1AD && Key1AD<=Res2R5MaxAD)
        {
#ifdef DEBUG
            printf("SEEK NEXT SW\n");
#endif
            USBLed=false;
            Keyboard->mediaControl(KEY_NEXT_TRACK);
            wait_ms(wait_time_keydet_ms);
        }   
        //SEEK- SW
        else if(Res300MinAD<=Key1AD && Key1AD<=Res300MaxAD)
        {
#ifdef DEBUG
            printf("SEEK PREV SW\n");
#endif
            USBLed=false;
            Keyboard->mediaControl(KEY_PREVIOUS_TRACK);
            wait_ms(wait_time_keydet_ms);
        }   

        //VOL+ SW
        else if(Res1kMinAD<=Key1AD && Key1AD<=Res1kMaxAD)
        {
#ifdef DEBUG
            printf("VOL UP SW\n");
#endif
            if(DEH970Ctrl->IsLocked()==false)
            {   IRLed=false;
                DEH970Ctrl->SendVolPlus();
                wait_ms(wait_time_keydet_ms);
            }
        }   
        //VOL- SW
        else if(Res3kMinAD<=Key1AD && Key1AD<=Res3kMaxAD)
        {
#ifdef DEBUG
            printf("VOL DOWN SW\n");
#endif
            if(DEH970Ctrl->IsLocked()==false)
            {   IRLed=false;
                DEH970Ctrl->SendVolMinus();
                wait_ms(wait_time_keydet_ms);
            }
        }

        wait_ms(wait_time_ms);
        HBLed=!HBLed;
    }
    
    // return(0);
}
