#ifndef _DEH970_CTRL_H_
#define _DEH970_CTRL_H_

#include "mbed.h"

#define DATA_LENGTH 4
#define IR_ON 0.5
#define IR_OFF 0

const int BurstPeriod=26;
const timestamp_t LeaderOn=8628;
const timestamp_t LeaderOff=4137;
const timestamp_t DataOn=626;    
const timestamp_t DataOff1=1488;
const timestamp_t DataOff0=424;
const timestamp_t TrailerOn=626;
const timestamp_t TrailerOff=25395;

class DEH970Controller {
protected:    
private:
    bool Locked;
    PwmOut *IRPort;
    int DataBitPos,DataBytePos;
    unsigned char *Data;
    bool DataBit;
    Timeout *TimeOutIR;


public:
    bool IsLocked();  
    DEH970Controller(PwmOut *Port);
    ~DEH970Controller();
    void PwmPortInit();
    void SendSignal(unsigned char *Dp);
    void SendLeaderOn();
    void SendData();
    
    void SendVolPlus();
    void SendVolMinus();
};

#endif