#include "DEH970Ctrl.h"


unsigned char VolPlus[DATA_LENGTH]={0xB5,0x4A,0x50,0xAF};
//unsigned char VolPlus[DATA_LENGTH]={0x55,0xAA,0xA5,0x5A};
unsigned char VolMinus[DATA_LENGTH]={0xB5,0x4A,0xD0,0x2F};   

DEH970Controller::DEH970Controller(PwmOut *Port)
{
    Locked=false;
    IRPort=Port;
    
    PwmPortInit();
}

DEH970Controller::~DEH970Controller()
{
    
}

bool DEH970Controller::IsLocked()
{
    return Locked;   
}

void DEH970Controller::PwmPortInit()
{
#ifdef DEBUG
    printf("PWM Port Init\n");
#endif
    IRPort->period_us(BurstPeriod);
    IRPort->write(IR_OFF);    
}

void  DEH970Controller::SendSignal(unsigned char *Dp)
{
    DataBitPos=0;
    DataBytePos=-1;
    Data=Dp;
    DataBit=false;
    TimeOutIR=NULL;
#ifdef DEBUG
    printf("SendSignal\n");
#endif
    SendData();
}

void DEH970Controller::SendData()
{
    timestamp_t WaitTime;

    if(TimeOutIR!=NULL)
        delete TimeOutIR;

    TimeOutIR=new Timeout();
    DataBit=!DataBit;

#ifdef DEBUG
    printf("%d %d %d\n",DataBytePos,DataBitPos,DataBit);
#endif
    // Send Leader
    if(DataBytePos==-1)
    {
        WaitTime=DataBit?LeaderOn:LeaderOff;
        IRPort->write(DataBit?IR_ON:IR_OFF);
        if(!DataBit)
            DataBytePos++;
    }
    // Send Trailer
    else if(DataBytePos==DATA_LENGTH)
    {
        WaitTime=DataBit?TrailerOn:TrailerOff;
        IRPort->write(DataBit?IR_ON:IR_OFF);
        if(!DataBit)
            DataBytePos++;
    }
    // Finish if Sent Trailer
    else if(DataBytePos==DATA_LENGTH+1)    
    {
#ifdef DEBUG
            printf("finished\n");
#endif
           return;
    }
    // Send Data
    else
    {
        if(DataBit)
            WaitTime=DataOn;
        else
            WaitTime=((((int)Data[DataBytePos])&(0x00000080>>DataBitPos))==0)?DataOff0:DataOff1;
#ifdef DEBUG2
        printf("%x\n",(((int)Data[DataBytePos])&(0x00000080>>DataBitPos))!=0);
#endif
        IRPort->write(DataBit?IR_ON:IR_OFF);
        if(!DataBit)
        {   DataBitPos=(DataBitPos+1)%8;
            if(DataBitPos==0)
                DataBytePos++;
        }
    }

    TimeOutIR->attach_us(this,&DEH970Controller::SendData,WaitTime);
}

void DEH970Controller::SendVolPlus()
{
#ifdef DEBUG
    printf("Send Vol Plus\n");
#endif
    SendSignal(VolPlus);
}

void DEH970Controller::SendVolMinus()
{
    SendSignal(VolMinus);
}