#include "EnvServer.h"
#include "Sensor.h"

Select select;
tcp::Socket server;
tcp::Socket client[MAX_CLIENTS];
tcp::Socket *socket = NULL;

void EnvServer(void const *arg)
{
    int result = 0;
    int index = 0;
    int num=0;
    char SendBuf[16];
    network::Buffer buffer(256);
    //std::string message("Hello world!");

    // Configure the server socket (assume everty thing works)
    server.open();
    server.bind(WAIT_PORT);
    server.listen(MAX_CLIENTS);
    printf("Start waiting ...\r\n");
    
    // Add sockets to the select api
    select.set(&server, Select::Read);
    for (index = 0; index < MAX_CLIENTS; index++) {
        select.set(&client[index], Select::Read);
    }

    do {
        // Wait for activity
        result = select.wait();
        if (result < -1) {
            printf("Failed to select\n\r");
            break;
        }

        // Get the first socket
        socket = (tcp::Socket *)select.getReadable();

        for (; socket != NULL; socket = (tcp::Socket *)select.getReadable()) {
            // Check if there was a connection request.
            if (socket->getHandle() == server.getHandle()) {
                // Find an unused client
                for (index = 0; index < MAX_CLIENTS; index++) {
                    if (client[index].getStatus() == network::Socket::Closed) {
                        break;
                    }
                }

                // Maximum connections reached
                if (index == MAX_CLIENTS) {
                    printf("Maximum connections reached\n\r");
                    continue;
                }

                // Accept the client
                socket->accept(client[index]);
                printf("Client connected %s:%d\n\r",
                       client[index].getRemoteEndpoint().getAddress().toString().c_str(),
                       client[index].getRemoteEndpoint().getPort());

                // Send a nice message to the client
                //client[index].write((void *)message.data(), message.size());
                continue;
            }

            // It was not the server socket, so it must be a client talking to us.
            num=socket->read(buffer);
            switch (num) {
                case 0:
                    // Remote end disconnected
                    printf("Client disconnected %s:%d\n\r",
                           socket->getRemoteEndpoint().getAddress().toString().c_str(),
                           socket->getRemoteEndpoint().getPort());

                    // Close socket
                    socket->close();
                    break;

                case -1:
                    printf("Error while reading data from socket\n\r");
                    socket->close();
                    break;

                default:
                    printf("Message from %s:%d\n\r",
                           socket->getRemoteEndpoint().getAddress().toString().c_str(),
                           socket->getRemoteEndpoint().getPort());

                    //command
                    if(strcmp((char *)buffer.data(),TEMP_CMD)==0) {
                        printf("Temperature:\r\n");
                        sprintf(SendBuf,"%2.2f",pSensor->getTemperature());
                    } else if(strcmp((char *)buffer.data(),HUMIDITY_CMD)==0) {
                        printf("Humidity:\r\n");
                        sprintf(SendBuf,"%3.2f",pSensor->getHumidity());
                    } else if(strcmp((char *)buffer.data(),PRESSURE_CMD)==0) {
                        printf("Pressure:\r\n");
                        sprintf(SendBuf,"%4.2f",pSensor->getPressure());
                    } else if(strcmp((char *)buffer.data(),ILLUM_CMD)==0) {
                        printf("Illuminance:\r\n");
                        sprintf(SendBuf,"%5.2f",pLumSensor->getLux());
                    } else {
                        printf("Unknown command:\r\n");
                        sprintf(SendBuf,"NG");
                    }

                    socket->write((void *)SendBuf,strlen(SendBuf));

                    printf("Command:%s Result:%s\n\r", (char *)buffer.data(),SendBuf);
            }
        }

    } while (server.getStatus() == network::Socket::Listening);
}
